/*
 * Decompiled with CFR 0.152.
 */
package org.icij.spewer;

import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import org.apache.commons.io.TaggedIOException;
import org.apache.tika.metadata.Metadata;
import org.icij.extract.document.TikaDocument;
import org.icij.spewer.FieldNames;
import org.icij.spewer.MetadataTransformer;
import org.icij.spewer.Spewer;

public class PrintStreamSpewer
extends Spewer
implements Serializable {
    private static final long serialVersionUID = -1952187923616552629L;
    private final PrintStream stream;

    public PrintStreamSpewer(PrintStream stream, FieldNames fields) {
        super(fields);
        this.stream = stream;
    }

    @Override
    protected void writeDocument(TikaDocument tikaDocument, TikaDocument parent, TikaDocument root, int level) throws IOException {
        if (this.outputMetadata) {
            this.writeMetadata(tikaDocument);
        }
        this.copy(tikaDocument.getReader(), this.stream);
        this.stream.println();
        if (this.stream.checkError()) {
            throw new TaggedIOException(new IOException("Error writing to print stream."), (Serializable)this);
        }
    }

    private void writeMetadata(TikaDocument tikaDocument) throws IOException {
        Metadata metadata = tikaDocument.getMetadata();
        if (null != this.fields.forPath()) {
            this.stream.println(this.fields.forPath() + ": " + tikaDocument.getPath().toString());
        }
        if (null != this.fields.forParentPath() && tikaDocument.getPath().getNameCount() > 1) {
            this.stream.println(this.fields.forParentPath() + ": " + tikaDocument.getPath().getParent().toString());
        }
        new MetadataTransformer(metadata, this.fields).transform((name, value) -> this.stream.println(name + ": " + value), (name, values) -> this.stream.println(name + ": " + String.join((CharSequence)", ", values)));
        this.stream.println();
    }

    @Override
    public void close() throws Exception {
        this.stream.close();
    }
}

