/*
 * Decompiled with CFR 0.152.
 */
package org.icij.swagger;

import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.fasterxml.jackson.databind.introspect.AnnotatedParameter;
import com.fasterxml.jackson.databind.type.TypeFactory;
import io.swagger.v3.core.util.AnnotationsUtils;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.core.util.ParameterProcessor;
import io.swagger.v3.core.util.ReflectionUtils;
import io.swagger.v3.jaxrs2.Reader;
import io.swagger.v3.jaxrs2.ResolvedParameter;
import io.swagger.v3.jaxrs2.SecurityParser;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtension;
import io.swagger.v3.jaxrs2.ext.OpenAPIExtensions;
import io.swagger.v3.oas.annotations.ExternalDocumentation;
import io.swagger.v3.oas.annotations.OpenAPIDefinition;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.info.Info;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.security.SecurityRequirement;
import io.swagger.v3.oas.annotations.servers.Server;
import io.swagger.v3.oas.annotations.tags.Tag;
import io.swagger.v3.oas.integration.api.OpenAPIConfiguration;
import io.swagger.v3.oas.models.Components;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Encoding;
import io.swagger.v3.oas.models.media.ObjectSchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponses;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import net.codestory.http.annotations.AnnotationHelper;
import net.codestory.http.annotations.Prefix;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FluentReader
extends Reader {
    private static final Logger LOGGER = LoggerFactory.getLogger(FluentReader.class);

    public FluentReader() {
    }

    public FluentReader(OpenAPI openAPI) {
        super(openAPI);
    }

    public FluentReader(OpenAPIConfiguration openApiConfiguration) {
        super(openApiConfiguration);
    }

    public OpenAPI read(Class<?> cls, String parentPath, String parentMethod, boolean isSubresource, RequestBody parentRequestBody, ApiResponses parentResponses, Set<String> parentTags, List<io.swagger.v3.oas.models.parameters.Parameter> parentParameters, Set<Class<?>> scannedResources) {
        OpenAPIDefinition openAPIDefinition = (OpenAPIDefinition)ReflectionUtils.getAnnotation(cls, OpenAPIDefinition.class);
        if (openAPIDefinition != null) {
            AnnotationsUtils.getInfo((Info)openAPIDefinition.info()).ifPresent(info -> this.getOpenAPI().setInfo(info));
            SecurityParser.getSecurityRequirements((SecurityRequirement[])openAPIDefinition.security()).ifPresent(s -> this.getOpenAPI().setSecurity(s));
            AnnotationsUtils.getExternalDocumentation((ExternalDocumentation)openAPIDefinition.externalDocs()).ifPresent(docs -> this.getOpenAPI().setExternalDocs(docs));
            AnnotationsUtils.getTags((Tag[])openAPIDefinition.tags(), (boolean)false).ifPresent(tags -> this.getOpenApiTags().addAll(tags));
            AnnotationsUtils.getServers((Server[])openAPIDefinition.servers()).ifPresent(servers -> this.getOpenAPI().setServers(servers));
            if (openAPIDefinition.extensions().length > 0) {
                this.getOpenAPI().setExtensions(AnnotationsUtils.getExtensions((Extension[])openAPIDefinition.extensions()));
            }
        }
        ApiResponse[] classResponses = (ApiResponse[])ReflectionUtils.getRepeatableAnnotationsArray(cls, ApiResponse.class);
        Tag[] apiTags = (Tag[])ReflectionUtils.getRepeatableAnnotationsArray(cls, Tag.class);
        Prefix classPrefix = (Prefix)ReflectionUtils.getAnnotation(cls, Prefix.class);
        if (classPrefix != null) {
            JavaType classType = TypeFactory.defaultInstance().constructType(cls);
            BeanDescription bd = Json.mapper().getSerializationConfig().introspect(classType);
            RouteCollection routeCollection = new RouteCollection();
            AnnotationHelper.parseAnnotations((String)"", cls, (httpMethod, uri, method) -> routeCollection.addResource(httpMethod, method, uri));
            for (RouteData route : routeCollection.routes) {
                Iterator chain;
                ResolvedParameter resolvedParameter;
                Type paramType;
                Parameter paramAnnotation;
                JavaType type;
                boolean methodDeprecated;
                io.swagger.v3.oas.annotations.Operation apiOperation = (io.swagger.v3.oas.annotations.Operation)ReflectionUtils.getAnnotation((Method)route.method, io.swagger.v3.oas.annotations.Operation.class);
                if (apiOperation == null) continue;
                AnnotatedMethod annotatedMethod = bd.findMethod(route.method.getName(), (Class[])route.method.getParameterTypes());
                Operation operation = this.parseMethod(route.method, null, null, null, null, null, new ArrayList(), Optional.empty(), null, null, isSubresource, parentRequestBody, parentResponses, null, classResponses, annotatedMethod);
                boolean bl = methodDeprecated = ReflectionUtils.getAnnotation((Method)route.method, Deprecated.class) != null;
                if (methodDeprecated) {
                    operation.setDeprecated(Boolean.valueOf(true));
                }
                ArrayList operationParameters = new ArrayList();
                ArrayList formParameters = new ArrayList();
                Annotation[][] paramAnnotations = ReflectionUtils.getParameterAnnotations((Method)route.method);
                if (annotatedMethod == null) {
                    Type[] genericParameterTypes = route.method.getGenericParameterTypes();
                    for (int i = 0; i < genericParameterTypes.length; ++i) {
                        type = TypeFactory.defaultInstance().constructType(genericParameterTypes[i], cls);
                        paramAnnotation = (Parameter)AnnotationsUtils.getAnnotation(Parameter.class, (Annotation[])paramAnnotations[i]);
                        paramType = ParameterProcessor.getParameterType((Parameter)paramAnnotation, (boolean)true);
                        if (paramType == null) {
                            paramType = type;
                        } else if (!(paramType instanceof Class)) {
                            paramType = type;
                        }
                        resolvedParameter = this.getParameters(paramType, Arrays.asList(paramAnnotations[i]), operation, null, null, null);
                        operationParameters.addAll(resolvedParameter.parameters);
                        formParameters.addAll(resolvedParameter.formParameters);
                        if (resolvedParameter.requestBody == null) continue;
                        this.processRequestBody(resolvedParameter.requestBody, operation, null, null, operationParameters, paramAnnotations[i], (Type)type, null, null);
                    }
                    continue;
                }
                for (int i = 0; i < annotatedMethod.getParameterCount(); ++i) {
                    AnnotatedParameter param = annotatedMethod.getParameter(i);
                    type = TypeFactory.defaultInstance().constructType(param.getParameterType(), cls);
                    paramAnnotation = (Parameter)AnnotationsUtils.getAnnotation(Parameter.class, (Annotation[])paramAnnotations[i]);
                    paramType = ParameterProcessor.getParameterType((Parameter)paramAnnotation, (boolean)true);
                    if (paramType == null) {
                        paramType = type;
                    } else if (!(paramType instanceof Class)) {
                        paramType = type;
                    }
                    resolvedParameter = this.getParameters(paramType, Arrays.asList(paramAnnotations[i]), operation, null, null, null);
                    operationParameters.addAll(resolvedParameter.parameters);
                    formParameters.addAll(resolvedParameter.formParameters);
                }
                if (!formParameters.isEmpty()) {
                    ObjectSchema mergedSchema = new ObjectSchema();
                    LinkedHashMap<String, Encoding> encoding = new LinkedHashMap<String, Encoding>();
                    for (io.swagger.v3.oas.models.parameters.Parameter formParam : formParameters) {
                        if (formParam.getExplode() != null || formParam.getStyle() != null && Encoding.StyleEnum.fromString((String)formParam.getStyle().toString()) != null) {
                            Encoding e = new Encoding();
                            if (formParam.getExplode() != null) {
                                e.explode(formParam.getExplode());
                            }
                            if (formParam.getStyle() != null && Encoding.StyleEnum.fromString((String)formParam.getStyle().toString()) != null) {
                                e.style(Encoding.StyleEnum.fromString((String)formParam.getStyle().toString()));
                            }
                            encoding.put(formParam.getName(), e);
                        }
                        mergedSchema.addProperties(formParam.getName(), formParam.getSchema());
                        if (formParam.getSchema() != null && StringUtils.isNotBlank((CharSequence)formParam.getDescription()) && StringUtils.isBlank((CharSequence)formParam.getSchema().getDescription())) {
                            formParam.getSchema().description(formParam.getDescription());
                        }
                        if (null == formParam.getRequired() || !formParam.getRequired().booleanValue()) continue;
                        mergedSchema.addRequiredItem(formParam.getName());
                    }
                    io.swagger.v3.oas.models.parameters.Parameter parameter = new io.swagger.v3.oas.models.parameters.Parameter().schema((Schema)mergedSchema);
                }
                if (!operationParameters.isEmpty()) {
                    for (io.swagger.v3.oas.models.parameters.Parameter operationParameter : operationParameters) {
                        operation.addParametersItem(operationParameter);
                    }
                }
                if (parentParameters != null) {
                    for (io.swagger.v3.oas.models.parameters.Parameter parentParameter : parentParameters) {
                        operation.addParametersItem(parentParameter);
                    }
                }
                if ((chain = OpenAPIExtensions.chain()).hasNext()) {
                    OpenAPIExtension extension = (OpenAPIExtension)chain.next();
                    extension.decorateOperation(operation, route.method, chain);
                }
                PathItem pathItemObject = this.getOpenAPI().getPaths() != null && this.getOpenAPI().getPaths().get((Object)route.uriPattern) != null ? (PathItem)this.getOpenAPI().getPaths().get((Object)route.uriPattern) : new PathItem();
                if (StringUtils.isBlank((CharSequence)route.httpMethod)) continue;
                this.setPathItemOperation(pathItemObject, route.httpMethod, operation);
                this.getPaths().addPathItem(route.uriPattern, pathItemObject);
                if (this.getOpenAPI().getPaths() != null) {
                    this.getPaths().putAll((Map)this.getOpenAPI().getPaths());
                }
                this.getOpenAPI().setPaths(this.getPaths());
                LOGGER.info("added method {}.{} ({}) to openAPI", new Object[]{cls.getName(), route.method.getName(), route.httpMethod});
            }
            if (!this.isEmptyComponents(this.getComponents()) && this.getOpenAPI().getComponents() == null) {
                this.getOpenAPI().setComponents(this.getComponents());
            }
            AnnotationsUtils.getTags((Tag[])apiTags, (boolean)true).ifPresent(this.getOpenApiTags()::addAll);
            if (!this.getOpenApiTags().isEmpty()) {
                LinkedHashSet<io.swagger.v3.oas.models.tags.Tag> tagsSet = new LinkedHashSet<io.swagger.v3.oas.models.tags.Tag>();
                if (this.getOpenAPI().getTags() != null) {
                    for (io.swagger.v3.oas.models.tags.Tag tag : this.getOpenAPI().getTags()) {
                        if (!tagsSet.stream().noneMatch(t -> t.getName().equals(tag.getName()))) continue;
                        tagsSet.add(tag);
                    }
                }
                for (io.swagger.v3.oas.models.tags.Tag tag : this.getOpenApiTags()) {
                    if (!tagsSet.stream().noneMatch(t -> t.getName().equals(tag.getName()))) continue;
                    tagsSet.add(tag);
                }
                this.getOpenAPI().setTags(new ArrayList(tagsSet));
            }
        }
        return this.getOpenAPI();
    }

    private boolean isEmptyComponents(Components components) {
        if (components == null) {
            return true;
        }
        if (components.getSchemas() != null && components.getSchemas().size() > 0) {
            return false;
        }
        if (components.getSecuritySchemes() != null && components.getSecuritySchemes().size() > 0) {
            return false;
        }
        if (components.getCallbacks() != null && components.getCallbacks().size() > 0) {
            return false;
        }
        if (components.getExamples() != null && components.getExamples().size() > 0) {
            return false;
        }
        if (components.getExtensions() != null && components.getExtensions().size() > 0) {
            return false;
        }
        if (components.getHeaders() != null && components.getHeaders().size() > 0) {
            return false;
        }
        if (components.getLinks() != null && components.getLinks().size() > 0) {
            return false;
        }
        if (components.getParameters() != null && components.getParameters().size() > 0) {
            return false;
        }
        if (components.getRequestBodies() != null && components.getRequestBodies().size() > 0) {
            return false;
        }
        return components.getResponses() == null || components.getResponses().size() <= 0;
    }

    private void setPathItemOperation(PathItem pathItemObject, String method, Operation operation) {
        switch (method) {
            case "POST": {
                pathItemObject.post(operation);
                break;
            }
            case "GET": {
                pathItemObject.get(operation);
                break;
            }
            case "DELETE": {
                pathItemObject.delete(operation);
                break;
            }
            case "PUT": {
                pathItemObject.put(operation);
                break;
            }
            case "PATCH": {
                pathItemObject.patch(operation);
                break;
            }
            case "TRACE": {
                pathItemObject.trace(operation);
                break;
            }
            case "HEAD": {
                pathItemObject.head(operation);
                break;
            }
            case "OPTIONS": {
                pathItemObject.options(operation);
                break;
            }
        }
    }

    private static class RouteData
    implements Comparable<RouteData> {
        final String httpMethod;
        final Method method;
        final String uriPattern;

        private RouteData(String httpMethod, Method method, String uriPattern) {
            this.httpMethod = httpMethod;
            this.method = method;
            this.uriPattern = uriPattern;
        }

        @Override
        public int compareTo(RouteData other) {
            int uriPatternResult = this.uriPattern.compareTo(other.uriPattern);
            return uriPatternResult == 0 ? this.httpMethod.compareTo(other.httpMethod) : uriPatternResult;
        }
    }

    private static class RouteCollection {
        Set<RouteData> routes = new TreeSet<RouteData>();

        private RouteCollection() {
        }

        protected void addResource(String httpMethod, Method method, String uriPattern) {
            this.routes.add(new RouteData(httpMethod, method, uriPattern));
        }
    }
}

