package org.icroco.tablemodel;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.swing.JTable;

/**
 * This annotation can be only used on getter (base on naming convention (get*()
 * or is*()) and represent properties to display into a {@link JTable by
 * creation of a BeanTableModel}.
 * 
 * @version $Revision: 1.4 $
 * 
 */
@Inherited
@Documented
@Target( { ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface ABeanTableModelProperty
{
	/**
	 * This value is: #FF9999 (light yellow)
	 */
	String DEFAULT_SORT_KEY = "ZZZZZZ";

	// Class NULL_CLASS = Void.class;

	/**
	 * @return a unique id for a bean property (a couple of getter/setter for a
	 *         property). This is is used as label to display into column header
	 *         when no resources are specified.
	 */
	String name();

	/**
	 * @return true if this attribute can be modified directly by the end-user. if true it require a right setter method.
	 */
	boolean isEditable() default false;

	/**
	 * @return a string litteral used to find the initiale column order. For
	 *         example if a properties as a orderKey "B" and other one as "A",
	 *         this last should be diplsayed in the first table column.
	 */
	String orderKey() default DEFAULT_SORT_KEY;
	
}
