package org.icroco.tablemodel.blinking;

import java.awt.Color;
import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.icroco.tablemodel.ABeanTableModel;
import org.icroco.tablemodel.ABeanTableModelProperty;

/**
 * This annotation can only be used on :
 * <ul>
 * <li>Method type in conjunction of ({@link ABeanTableModelProperty} for
 * getter) but this annotation is reserved for setter side.</li>
 * <li>Class type to define default option when you have to put annotation on
 * all setter method.
 * <li>
 * </ul>
 * 
 * @author ouaibsky@gmail.com
 * 
 */
@Inherited
@Documented
@Target( {	ElementType.TYPE,
			ElementType.METHOD })
@Retention(RetentionPolicy.RUNTIME)
public @interface ABlinking
{
	/**
	 * This value is: #FF9999 (light yellow)
	 */
	String DEFAULT_COLOR = "default";

	/**
	 * mode
	 */
	EBlinkingMode mode() default EBlinkingMode.DEFAULT;

	/**
	 * duration represents duration of cell flashing in milliseconds. Default is
	 * 500 ms.
	 */
	int duration() default -1;

	/**
	 * repeat represents number of flashing for one update. Let fill 1 when you
	 * have many flashing. It could make sens to increase this value on large
	 * model with a little number of update to catch your eye. Default value is
	 * 1.
	 */
	int repeat() default -1;

	/**
	 * background color under format used by {@link Color#decode(String)}. Used
	 * into {@link EBlinkingMode#COLOR} and {@link EBlinkingMode#BORDER}
	 * 
	 * @return by default {@link #DEFAULT_BG_COLOR}. Could be empty string (no
	 *         specific background).
	 */
	String bgColor() default DEFAULT_COLOR;

	/**
	 * @return empty string by default (means no specific foreground). Used into
	 *         {@link EBlinkingMode#COLOR} and {@link EBlinkingMode#FONT}
	 */
	String fgColor() default DEFAULT_COLOR;

	/**
	 * Only accepted when used at TYPE leve (Class). If true we try to find all
	 * setters corresponding to getters annotate with
	 * {@link ABeanTableModelProperty} (or
	 * {@link ABeanTableModel#autoAddAllGetters()}) and we activate blinking for
	 * them.
	 * 
	 * @return
	 */
	boolean autoAddAllSetters() default false;

}
