package org.icroco.tablemodel.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;

/**
 * EmptyLock is used to manage let choice of locking or not into {@link BeanTableModel}.
 * 
 * @author ouaibsky - 22 avr. 2009
 * 
 */
public final class EmptyLock
		implements ReadWriteLock
{
	static class NullLock
			implements Lock
	{
		@Override
		public void lock()
		{
			// Nothing
		}

		@Override
		public void lockInterruptibly() throws InterruptedException
		{
			// Nothing
		}

		@Override
		public Condition newCondition()
		{
			throw new UnsupportedOperationException();
		}

		/**
		 * (non-Javadoc)
		 * 
		 * @see java.util.concurrent.locks.Lock#tryLock()
		 */
		@Override
		public boolean tryLock()
		{
			return true;
		}

		@Override
		public boolean tryLock(long aTime, TimeUnit aUnit) throws InterruptedException
		{
			return true;
		}

		@Override
		public void unlock()
		{
			// Nothing
		}

	}

	private final static Lock emptyLock = new NullLock();

	@Override
	public Lock readLock()
	{
		return emptyLock;
	}

	@Override
	public Lock writeLock()
	{
		return emptyLock;
	}
}
