package org.icroco.tablemodel.impl.blinking;

/**
 * CellFlashColorRenderer
 *
 * Specialised renderer class for flashing the colors of a cell
 *
 * @author L.D'Abreo
 *
 * @see TableCellRenderer
 * @see JTable
 * @see CellFlashProvider
 */
import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;

import org.icroco.tablemodel.blinking.CellFlashProvider;

/**
 * BlinkColorRendererStage.
 * 
 * @author ouaibsky - 22 avr. 2009
 * 
 */
public class BlinkColorRendererStage
    extends AbstractBlinhRendererStage
{
    final Color bgrd;
    final Color fgrd;
    
    public BlinkColorRendererStage(final CellFlashProvider aProvider, final Color aBackground, final Color aForeground)
    {
        super(aProvider);
        this.fgrd = aForeground;
        this.bgrd = aBackground;
    }
    
    public BlinkColorRendererStage(final CellFlashProvider aProvider, final Color aBackground)
    {
        this(aProvider, aBackground, null);
    }
    
    /**
     * @param aDelegate
     * @param aProvider
     */
    public BlinkColorRendererStage(final CellFlashProvider aProvider)
    {
        this(aProvider, Color.RED);
    }
    
    @Override
    public void render(final Component aRendered, final JTable aTable, final Object aValue, final boolean aIsSelected,
                       final boolean aHasFocus, final int aRow, final int aColumn)
    {
        final int mCol = aTable.convertColumnIndexToModel(aColumn);
        final int mRow = aTable.convertRowIndexToModel(aRow);
        // invert the colors to flash
        if (this.provider.isFlashOn(mRow, mCol))
        {
            if (this.bgrd != null)
            {
                aRendered.setBackground(this.bgrd);
            }
            if (this.fgrd != null)
            {
                aRendered.setForeground(this.fgrd);
            }
        }
    }
}