package org.icroco.tablemodel.impl.blinking;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;

import javax.swing.JComponent;
import javax.swing.JTable;

import org.icroco.tablemodel.blinking.CellFlashProvider;

/**
 * BlinkFontRendererStage.
 * 
 * @author ouaibsky - 22 avr. 2009
 * 
 */
public class BlinkFontRendererStage
    extends AbstractBlinhRendererStage
{
    final static int style = Font.BOLD | Font.ITALIC;
    final Color      fgrd;
    
    /**
     * @param aDelegate
     * @param aProvider
     */
    public BlinkFontRendererStage(final CellFlashProvider aProvider, final Color aFgColor)
    {
        super(aProvider);
        this.fgrd = aFgColor;
    }
    
    @Override
    public void render(final Component aRendered, final JTable aTable, final Object aValue, final boolean aIsSelected,
                       final boolean aHasFocus, final int aRow, final int aColumn)
    {
        // Convert view column to model column
        final int mCol = aTable.convertColumnIndexToModel(aColumn);
        final int mRow = aTable.convertRowIndexToModel(aRow);
        
        // italic and bold the Font to flash
        final JComponent jc = (JComponent) aRendered;
        final Font f = jc.getFont();
        
        if (this.provider.isFlashOn(mRow, mCol))
        {
            jc.setFont(f.deriveFont(style));
            // if (this.fgrd != null)
            // aRendered.setForeground(this.fgrd);
        }
        else
        {
            jc.setFont(f.deriveFont(Font.PLAIN));
        }
    }
}
