package org.icroco.tablemodel.impl.blinking;

import java.awt.Color;

import org.icroco.tablemodel.blinking.EBlinkingMode;
import org.icroco.tablemodel.impl.TableModelProperty;

/**
 * @author ouaibsky@gmail.com
 * 
 */
public final class TableModelBlinkProperty
    extends TableModelProperty
{
    private boolean       blink;
    private EBlinkingMode mode;
    private Color         blinkBgColor;
    private Color         blinkFgColor;
    private int           duration;
    private int           repeat;
    final static String   DEFAULT_BG_COLOR = "#FF9999";
    
    /**
	 * 
	 */
    public TableModelBlinkProperty()
    {
        super();
        this.blink = false;
        this.blinkBgColor = Color.decode(TableModelBlinkProperty.DEFAULT_BG_COLOR);
        this.blinkFgColor = null;
        this.mode = EBlinkingMode.COLOR;
        this.repeat = 1;
        this.duration = 500;
    }
    
    /**
     * @return the blinkBgColor
     */
    final Color getBlinkBgColor()
    {
        return this.blinkBgColor;
    }
    
    /**
     * @return the blinkFgColor
     */
    final Color getBlinkFgColor()
    {
        return this.blinkFgColor;
    }
    
    /**
     * @return the duration
     */
    final int getDuration()
    {
        return this.duration;
    }
    
    /**
     * @return the mode
     */
    final EBlinkingMode getMode()
    {
        return this.mode;
    }
    
    /**
     * @return the repeat
     */
    final int getRepeat()
    {
        return this.repeat;
    }
    
    /**
     * @return the blink
     */
    final boolean isBlink()
    {
        return this.blink;
    }
    
    /**
     * @param aBlink
     *            the blink to set
     */
    final void setBlink(final boolean aBlink)
    {
        this.blink = aBlink;
    }
    
    /**
     * @param aBlinkBgColor
     *            the blinkBgColor to set
     */
    final void setBlinkBgColor(final Color aBlinkBgColor)
    {
        this.blinkBgColor = aBlinkBgColor;
    }
    
    /**
     * @param aBlinkFgColor
     *            the blinkFgColor to set
     */
    final void setBlinkFgColor(final Color aBlinkFgColor)
    {
        this.blinkFgColor = aBlinkFgColor;
    }
    
    /**
     * @param aDuration
     *            the duration to set
     */
    final void setDuration(final int aDuration)
    {
        this.duration = aDuration;
    }
    
    /**
     * @param aMode
     *            the mode to set
     */
    final void setMode(final EBlinkingMode aMode)
    {
        this.mode = aMode;
    }
    
    /**
     * @param aRepeat
     *            the repeat to set
     */
    final void setRepeat(final int aRepeat)
    {
        this.repeat = aRepeat;
    }
    
    @Override
    public String toString()
    {
        // Not use of StringBuilder because it's just for debugging.
        if (isBlink())
        {
            return super.toString() + " blink:\"" + isBlink() + "\" blinkMode:\"" + this.mode + "\" duration:\"" + this.duration + "\" repeat:\""
                    + this.repeat + "\" bgColor:\"" + this.blinkBgColor + "\" fgColor:\"" + this.blinkFgColor + "\"";
        }
        else
        {
            return super.toString() + " blink:\"" + isBlink()+"\"";
        }
    }
    
}
