/**
 * 
 */
package org.icroco.tablemodel.renderer;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

import org.icroco.tablemodel.ABeanTableModelProperty;

/**
 * This annotation can be used at class level (type) or method level (only on getter). Processing order is Class level
 * then override with annotation method.<br/>
 * This annotation work only in cohabitation with {@link ABeanTableModelProperty}.
 * 
 * @version $Revision: 1.4 $
 * 
 */
@Inherited
@Documented
@Target( { ElementType.METHOD, ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
public @interface ARendererStages
{
	/**
	 * tableCellRenderer define initial renderer used for as main delegate before applying {@link IRendererStage}. Value
	 * is optional and default is {@link TableCellRenderer}, that mean we do not install a specific renderer and get
	 * renderer by invoking {@link JTable#getCellRenderer(int, int)}.
	 * 
	 * @return
	 */
	Class<? extends TableCellRenderer> tableCellRenderer() default TableCellRenderer.class;

	/**
	 * @return an array of class implementation of {@link IRendererStage}. this parameter is mandatory. implementation
	 *         has to implements a public constructor with a String parameter.<br/>
	 *         Order is important because {@link PipelineTableCellRenderer} keep this order to apply
	 *         {@link IRendererStage}.
	 */
	Class<? extends IRendererStage>[] stages();

	/**
	 * parameters is an string array passed to default constructor of {@link IRendererStage} implementation.<br/>
	 * Size an order must match the {@link #stages()} size (or at least less or equal). It means we call constructor of
	 * stages[0] with stagesParameters[0] .. etc.
	 * 
	 * @return
	 */
	String[] stagesParameters() default "";
}
