package org.icroco.tablemodel.renderer.plugin;

import java.awt.Color;
import java.awt.Component;
import java.text.SimpleDateFormat;
import java.util.Map;

import javax.swing.JTable;

import org.icroco.tablemodel.renderer.IRendererStage;

/**
 * CellColorRenderStage.
 * 
 * @author clalleme - 26 mai 08
 * 
 */
public final class CellColorRenderStage
    implements IRendererStage
{
    private Color bgColor;
    private Color fgColor;
    
    /**
     * Constructor.
     * 
     * @param aBgColor
     * @param aFgColor
     */
    public CellColorRenderStage(Color aBgColor, Color aFgColor)
    {
        super();
        this.bgColor = aBgColor;
        this.fgColor = aFgColor;
    }

    public CellColorRenderStage(Color aBgColor)
    {
        this(aBgColor, null);
    }

    public CellColorRenderStage()
    {
        this(null, null);
    }
    
    /**
     * aParameters can contains 1 or 2 colors argument. Possible value for each parameters is
     * <ul>
     * <li>Constant color as define into {@link Color}. For example: RED.</li>
     * <li>Or a web encoded value like #FF9999 (yellow light)</li>
     * </ul>
     * First parameter represents <b>background color</b><br/>
     * . Second parameter represents <b>foreground color</b>.
     * 
     * @throws NoSuchFieldException
     * @throws IllegalAccessException
     * @throws SecurityException
     * @throws IllegalArgumentException
     * @throws NumberFormatException
     * 
     * @see org.icroco.tablemodel.renderer.IRendererStage#init(java.lang.String)
     */
    public CellColorRenderStage(String aParameters)
        throws NumberFormatException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException
    {
        this(null, null);
		final Map<String, String> res = ParametersUtil.parseValue(aParameters);
		final String bgColor = res.get("bg");
		final String fgColor = res.get("fg");

		if (bgColor == null)
			throw new IllegalArgumentException("You forget to set parameter 'bg', possible value are '#webcode' or 'static color field define into java.awt.Color'");

        this.bgColor = ParametersUtil.decodeColor(bgColor);
        if (fgColor != null)
            this.fgColor = ParametersUtil.decodeColor(fgColor);
    }
    
    @Override
    public void initRenderer(Class<?> aColumnClass, Component aRendered)
    {
        // NOTHING
    }
    
    @Override
    public Object preRender(JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn)
    {
        return aValue;
    }
    
    @Override
    public void render(Component aRendered, JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn)
    {
        if (this.bgColor != null)
            aRendered.setBackground(this.bgColor);
        if (this.fgColor != null)
            aRendered.setBackground(this.fgColor);
    }
}