package org.icroco.tablemodel.renderer.plugin;

import java.lang.reflect.Array;

import org.icroco.tablemodel.renderer.IHistoricalValue;

class DefaultHistoricalValue<V extends Number>
    implements IHistoricalValue<V>
{
    public V[] array;
    public int first, next;
    
    @SuppressWarnings("unchecked")
    public DefaultHistoricalValue(final int aHistoricalSize)
    {
        final V[] v = (V[])new Object[0];
        this.array = (V[]) Array.newInstance(v.getClass().getComponentType(), aHistoricalSize);
        this.first = 0;
        this.next = 0;
    }
    
    @Override
    public boolean isEmpty()
    {
        return this.first == this.next;
    }
    
    @Override
    public void addValue(V aValue)
    {
        this.array[this.next] = aValue;
        this.next = (this.next + 1) % this.array.length; 
    }
    
    @Override
    public V getLast()
    {
        return this.array[this.next];
    }
    
    @Override
    public V getOld()
    {
        final int size = size();
        if (size == 1)
            return null;

        return this.array[this.next - 1];
    }
    
    @Override
    public V getOld(int aIndex) throws ArrayIndexOutOfBoundsException
    {
        if (aIndex >= size())
            throw new ArrayIndexOutOfBoundsException("Actual size is '"+size()+"'");
        return this.array[aIndex];
    }
    
    @Override
    public int size()
    {
        return this.next - this.first;
    }
    
    @Override
    public String toString()
    {
        return size() == 0 ? "" : this.array[this.next].toString();
    }
    
}
