package org.icroco.tablemodel.renderer.plugin;

import java.awt.Color;
import java.util.HashMap;
import java.util.Map;

/**
 * @author ouaibsky@gmail.com
 *
 */
public final class ParametersUtil
{
	public static Map<String, String> parseValue(final String aParameters)
	{
		return parseValue(aParameters, ",", "=");
	}

	public static Map<String, String> parseValue(final String aParameters, final String aFieldSeparetor, final String aValueSeparator)
	{
		final Map<String, String> lReturn = new HashMap<String, String>();

		if (aParameters == null)
			return lReturn;
		
		final String params = aParameters.trim();
		if (params.length() == 0)
			return lReturn;
		
		final String[] args = aParameters.split(aFieldSeparetor);
		for (String arg : args)
		{
			arg = arg.trim();
			final String[] keyValue = arg.split(aValueSeparator);
			if (keyValue.length <= 1)
				continue;
			
			lReturn.put(keyValue[0].trim(), keyValue[1].trim());
		}
		
		return lReturn;
	}
	
    public final static Color decodeColor(final String aColor) throws NumberFormatException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException
    {
    	return aColor.startsWith("#") ? Color.decode(aColor) : (Color) Color.class.getField(aColor).get(null);
    }

}
