package org.icroco.tablemodel;

import java.lang.annotation.Documented;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * This annotation is dedicated to Class definition and can be used to set global preference for {@link IBeanTableModel}.
 * 
 * @author ouaibsky@gmail.com
 * 
 */
@Documented
@Target( { ElementType.TYPE })
@Retention(RetentionPolicy.RUNTIME)
public @interface ABeanTableModel
{
    /**
     * @return if we have to synchronize method which update the model. it can occurs into 2 use cases:
     *         <ul>
     *         <li>If your model can be modify from view component (JTable) and programmaticaly from another thread</li>
     *         <li>If your model can be modify from many thread.</li>
     *         </ul>
     *         default is false.
     */
    boolean isTreadSafe() default false;
    
    /**
     * autoAddAllGetters can be used to parse all getters and expose them into the table model.<br/>
     * It the same thing that add the {@link ABeanTableModelProperty} on all setter but can be usefull when:
     * <ul>
     * <li>You want to annotate all your getters</li>
     * <li>You want to annotate all getters of another class just by overriding this class and add this annotation</li>
     * </ul>
     * 
     * Getter are determinate with java bean naming convention, it means :(start with <code>get</code> or <code>is</code> and
     * <ul>
     * <li>All methods which start by <code>get</code> or</li>
     * <li>All methods which start by <code>is</code> or</li>
     * </ul>
     * 
     * By default, properties are exposed on read only, to get a specific job, you can used {@link ABeanTableModelProperty}.
     * 
     * @return
     */
    boolean autoAddAllGetters() default false;
    
    /**
     * excludeGetters is used in combining of {@link #autoAddAllGetters()} and indicate some getter to exclude. You have to passe full
     * method name. Value can be multi-valued with comma separator.<br/>
     * For example <code>excludeGetters="getFoo, getBar";</code>
     * 
     * @return
     */
    String excludeGetters() default "";
}
