package org.icroco.tablemodel.impl;

import javax.swing.JTable;

import org.icroco.tablemodel.BeanTableModelException;
import org.icroco.tablemodel.TableModelFactory;

/**
 * package protected class to implements a {@link TableModelFactory}.
 * 
 * @author christophe
 * 
 */
public final class DefaultBeanTableModelFactory
{

	private DefaultBeanTableModelFactory()
	{
		super();

	}

	/**
	 * This is the better way to get a {@link BeanTableModel}. We make some stuff like JTable optimization for flashing,
	 * install renderer wrapper, ...
	 * 
	 * @param <B>
	 * @param aTable
	 * @param aClazz
	 * @return
	 * @throws BeanTableModelException
	 */
	@Deprecated
	public final static <B> BeanTableModel<B> createTableModel(final Class<B> aClazz) throws BeanTableModelException
	{
		return createTableModel(null, aClazz);
	}

	/**
	 * createTableModel has to be used when we have renderer to install.
	 * @param aTable
	 * @param aClazz
	 * 
	 * @param <B>
	 * @return
	 * @throws BeanTableModelException
	 */
	public final static <B> BeanTableModel<B> createTableModel(final JTable aTable, final Class<B> aClazz) throws BeanTableModelException
	{
		if (aClazz == null)
			throw new IllegalArgumentException("Parameters Class can not be null");

		final BeanTableModel<B> model = new BeanTableModel<B>(aClazz);
		model.parseAnnotation();
		if (aTable != null)
		{
			aTable.setModel(model);
			model.installRenderer(aTable);
		}

		return model;
	}

}
