package org.icroco.tablemodel.impl;

import java.lang.reflect.Method;
import java.text.MessageFormat;

import javax.swing.table.TableCellRenderer;

import org.icroco.tablemodel.renderer.IRendererStage;

/**
 * TableModelProperty.
 * 
 * @author ouaibsky - 22 avr. 2009
 * 
 */
public class TableModelProperty implements Comparable<TableModelProperty>
{
    private static final transient MessageFormat DUMP_11          = new MessageFormat(Messages.getString("BeanTableModel.11")); //$NON-NLS-1$

    String	name;
	String	label;
	boolean	isEditable;
    boolean hidden;
	String	orderKey;
	Class<?> columnClass;
	Method	setter;
	Method	getter;
	TableCellRenderer tableRenderer;
	IRendererStage renderers[];


	/**
	 *  (non-Javadoc)
	 * @see java.lang.Object#hashCode()
	 */
	@Override
	public int hashCode()
	{
		final int PRIME = 31;
		int result = 1;
		result = PRIME * result + ((this.name == null) ? 0 : this.name.hashCode());
		return result;
	}



	/**
	 *  (non-Javadoc)
	 * @see java.lang.Object#equals(java.lang.Object)
	 */
	@Override
	public boolean equals(Object obj)
	{
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		final TableModelProperty other = (TableModelProperty) obj;
		if (this.name == null)
		{
			if (other.name != null)
				return false;
		}
		else if (!this.name.equals(other.name))
			return false;
		return true;
	}



	/** 
	 * (non-Javadoc)
	 *
	 * @see java.lang.Comparable#compareTo(java.lang.Object)
	 */
	public int compareTo(TableModelProperty o)
	{
	    if (o == null || o.orderKey == null)
	        return 1;
	    
	    if (this.orderKey == null)
	        return -1;
	    
	    return this.orderKey.compareTo(o.orderKey);
	}
	

    /**
     *  (non-Javadoc)
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString()
    {
        return DUMP_11.format(new Object[] { this.name, 
                                             this.label,
                                             Boolean.valueOf(this.hidden),
                                             Boolean.valueOf(this.isEditable),
                                             this.orderKey,
                                             this.getter.getName(),
                                             this.setter == null ? "NO SETTER FOUND" : this.setter.getName()
        });
    }



	/**
	 * @return the setter
	 */
	public final Method getSetter()
	{
		return this.setter;
	}



	/**
	 * @return the getter
	 */
	public final Method getGetter()
	{
		return this.getter;
	}
    
    
    
}