package org.icroco.tablemodel.impl.blinking;

import java.awt.Color;
import java.awt.Component;

import javax.swing.JTable;

import org.icroco.tablemodel.blinking.CellFlashProvider;

/**
 * BlinkAnimatedColorRendererStage.
 * 
 * @author ouaibsky - 22 avr. 2009
 * 
 */
public final class BlinkAnimatedColorRendererStage
    extends BlinkColorRendererStage
{
	public BlinkAnimatedColorRendererStage(CellFlashProvider aProvider, final Color aBackground, final Color aForeground)
	{
		super(aProvider, aBackground, aForeground);
	}

	public BlinkAnimatedColorRendererStage(CellFlashProvider aProvider, final Color aBackground)
	{
		this(aProvider, aBackground, null);
	}
	/**
	 * @param aDelegate
	 * @param aProvider
	 */
	public BlinkAnimatedColorRendererStage(CellFlashProvider aProvider)
	{
		this(aProvider, Color.RED);
	}

	@Override
	public void render(Component aRendered, JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn)
	{
        // Convert view column to model column
        final int mCol = aTable.convertColumnIndexToModel(aColumn);
        final int mRow = aTable.convertRowIndexToModel(aRow);
        // invert the colors to flash
        final AnimatedCellFlasher cell = (AnimatedCellFlasher) this.provider.getFlashOn(mRow, mCol);
        if (cell != null)
        {
            if (this.bgrd != null)
                aRendered.setBackground(cell.getGradient(aRendered.getBackground(), this.bgrd));
            if (this.fgrd != null)
                aRendered.setForeground(this.fgrd);
        }
	}
   
}