package org.icroco.tablemodel.impl.blinking;

import java.awt.Color;
import java.awt.Component;

import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

import org.icroco.tablemodel.blinking.CellFlashProvider;

/**
 * BlinkBorderRendererStage.
 * 
 * @author ouaibsky - 22 avr. 2009
 * 
 */
public class BlinkBorderRendererStage
    extends AbstractBlinhRendererStage
{
    
    protected final Border        raised;
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected static final Border focusBorder   = UIManager.getBorder("Table.focusCellHighlightBorder");
    
    public BlinkBorderRendererStage(final CellFlashProvider aProvider, final Color aBorderColor)
    {
        super(aProvider);
        this.raised = BorderFactory.createLineBorder(aBorderColor);
    }
    
    public BlinkBorderRendererStage(final CellFlashProvider aProvider)
    {
        this(aProvider, Color.decode(TableModelBlinkProperty.DEFAULT_BG_COLOR));
    }
    
    @Override
    public void render(final Component aRendered, final JTable aTable, final Object aValue, final boolean aIsSelected,
                       final boolean aHasFocus, final int aRow, final int aColumn)
    {
        // TODO Auto-generated method stub
        // Convert view column to model column
        final int mCol = aTable.convertColumnIndexToModel(aColumn);
        final int mRow = aTable.convertRowIndexToModel(aRow);
        
        // invert the colours to flash
        final JComponent jc = (JComponent) aRendered;
        
        // If an abstract button e.g JCheckBox then set
        // border painted to true
        if (jc instanceof AbstractButton)
        {
            ((AbstractButton) jc).setBorderPainted(true);
        }
        if (this.provider.isFlashOn(mRow, mCol))
        {
            jc.setBorder(this.raised);
        }
        else
        {
            if (aHasFocus)
            {
                jc.setBorder(focusBorder);
            }
            else
            {
                jc.setBorder(noFocusBorder);
            }
        }
        
    }
}