package org.icroco.tablemodel.impl.blinking;

import javax.swing.JTable;

import org.icroco.tablemodel.BeanTableModelException;
import org.icroco.tablemodel.TableModelFactory;
import org.icroco.tablemodel.blinking.IBlinkTableModel;

/**
 * package protected class to implements a {@link TableModelFactory}.
 * 
 * @author ouaibsky
 * 
 */
public final class DefaultBeanBlinkTableModelFactory
{
    
    private DefaultBeanBlinkTableModelFactory()
    {
        super();
        
    }
    
    public final static <B> IBlinkTableModel<B> createBlinkTableModel(final JTable aTable, final Class<B> aClazz)
        throws BeanTableModelException
    {
        if (aTable == null || aClazz == null)
        {
            throw new IllegalArgumentException("Parameters can not be null");
        }
        
        final BeanBlinkTableModel<B> model = new BeanBlinkTableModel<B>(aTable, aClazz);
        model.parseAnnotation();
        aTable.setModel(model);
        model.installRenderer(); // to be done already after JTable.setModel or JTable.setColumnModel.
        
        return model;
    }
    
}
