package org.icroco.tablemodel.renderer;

import java.awt.Component;

import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

/**
 * RenderStage Based on Swingx STUFF
 * 
 * @author clalleme - 20 avr. 2009
 * 
 */
public interface IRendererStage
{
    /**
     * initRenderer can be used to make some stiff on renderer component just after initialization. This method is called only one time.
     * @param aColumnClass TODO
     * @param aRendered
     */
    public void initRenderer(final Class<?> aColumnClass, final Component aRendered);
    
    /**
     * preRender is called before calling standard
     * {@link TableCellRenderer#getTableCellRendererComponent(JTable, Object, boolean, boolean, int, int)}.
     * 
     * @return the modified value;
     */
    public Object preRender(final JTable aTable, final Object aValue, final boolean aIsSelected, final boolean aHasFocus, final int aRow, final int aColumn);
    
    /**
     * render.
     * 
     * @param aTable
     * @param aRendered
     * @param aValue
     * @param aIsSelected
     * @param aHasFocus
     * @param aRow
     * @param aColumn
     */
    public void render(final Component aRendered, final JTable aTable, final Object aValue, final boolean aIsSelected, final boolean aHasFocus, final int aRow, final int aColumn);
}
