/**
 * Renderpack Pipeline http://renderpack.dev.java.net/
 * 
 * COPYRIGHT 2004 Edward Dale
 */
package org.icroco.tablemodel.renderer.plugin;

import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;

import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;

import org.icroco.tablemodel.renderer.IRendererStage;

/**
 * DateRenderStage.
 * 
 * @author clalleme - 20 avr. 2009
 * 
 */
public final class DateRenderStage
    implements IRendererStage
{
    
    /** The {@link SimpleDateFormat} of the {@link Date}. */
    private DateFormat dateFormat = null;
    
    /**
     * Creates a new {@link DateRenderStage} that renders a {@link Date} using the specified {@link SimpleDateFormat}.
	 *            Possible value sub-string value are:<br/>
	 *            <ul>
	 *            <li><b>format</b>=<i>simple_date_format</i> (optional)</li>
	 *            </ul>
	 *            <b><i>simple_date_format</i></b> represent a String passed to  {@link SimpleDateFormat#parse(String)}.<br/>
     * 
     * @param aParameters
     *            The format to render the {@link Date} in.
     */
    public DateRenderStage(String aParameters)
    {
		final Map<String, String> res = ParametersUtil.parseValue(aParameters);
		final String format = res.get("format");

		if (format != null)
			this.dateFormat = new SimpleDateFormat(format);
		else
		    this.dateFormat = SimpleDateFormat.getDateInstance();
    }
    
    @Override
    public void initRenderer(Class<?> aColumnClass, Component aRendered)
    {
        // NOTHING
    }
    
    @Override
    public Object preRender(JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn)
    {
        return aValue;
    }
    
    /** {@inheritDoc} */
    public void render(Component aRendered, JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn)
    {
        // What to display
        if (aValue != null)
        {
            // canbe prepare into initRenderer;
            if (aRendered instanceof JLabel)
            {
                ((JLabel) aRendered).setText((aValue instanceof Date) ? this.dateFormat.format((Date) aValue) : aValue.toString());
            }
            else if (aRendered instanceof JTextComponent)
            {
                ((JTextComponent) aRendered).setText((aValue instanceof Date) ? this.dateFormat.format((Date) aValue) : aValue.toString());
            }
            
        }
    }
}
