package org.icroco.tablemodel.renderer.plugin;

import org.icroco.tablemodel.renderer.IHistoricalValue;

public class TwoDoubleHistoricalValue
extends Number
    implements IHistoricalValue<Double>
{
    /**
     * serialVersionUID
     */
    private static final long serialVersionUID = 1L;
    Double last;
    Double old;
    
    public TwoDoubleHistoricalValue(final Double aValue)
    {
        this.last = aValue;
        this.old = null;
    }

    @Override
    public void addValue(Double aValue)
    {
        this.old = this.last;
        this.last = aValue;
    }

    @Override
    public Double getLast()
    {
        return this.last;
    }

    @Override
    public Double getOld()
    {
        return this.old;
    }
    
    @Override
    public Double getOld(int aIndex) throws ArrayIndexOutOfBoundsException
    {
        if (aIndex > 1)
            throw new ArrayIndexOutOfBoundsException("MAximum size for this implementation is 2");
        return aIndex == 0 ? this.old : this.last;
    }

    @Override
    public boolean isEmpty()
    {
        return this.last == null && this.old == null;
    }

    @Override
    public int size()
    {
        return this.last == null ? 0 : (this.old != null ? 2 : 1);
    }
    
    @Override
    public String toString()
    {
        return this.last == null ? "" : this.last.toString();
    }

    @Override
    public double doubleValue()
    {
        return this.last.doubleValue();
    }

    @Override
    public float floatValue()
    {
        return this.last.floatValue();
    }

    @Override
    public int intValue()
    {
        return this.last.intValue();
    }

    @Override
    public long longValue()
    {
        return this.last.intValue();
    }
    
}
