/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.impl;

import java.lang.reflect.Method;
import org.icroco.tablemodel.BeanTableModelException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class BeanHelper {
    private static transient Logger logger = LoggerFactory.getLogger(BeanHelper.class);
    private static final String START_STR = "^";
    private static final String EMPTY_STR = "";
    private static final String SET_PREFIX = "set";
    private static final String GET_PREFIX = "get";
    private static final String IS_PREFIX = "is";

    private BeanHelper() {
    }

    public static boolean isGetter(Method aMethod) throws BeanTableModelException {
        String name = aMethod.getName();
        if (name.startsWith(GET_PREFIX) || name.startsWith(IS_PREFIX)) {
            if (aMethod.isVarArgs() || aMethod.getParameterTypes().length > 0) {
                throw new BeanTableModelException("Getter based on bean naming convemtion must have 0 parameters, method: " + aMethod);
            }
            if (aMethod.getReturnType().isPrimitive()) {
                throw new BeanTableModelException("Getter need to have non-primitive as return value" + aMethod);
            }
            return true;
        }
        throw new BeanTableModelException("You have to annotate getter based on bean naming convention: need to start by 'get' or 'is' prefix. method: " + aMethod);
    }

    public static boolean matchGetter(Method aMethod) {
        String name = aMethod.getName();
        if (name.startsWith(GET_PREFIX) || name.startsWith(IS_PREFIX)) {
            return !name.equals("getClass") || aMethod.getParameterTypes().length != 0;
        }
        return false;
    }

    public static final Method checkSetter(Class<?> aClazz, Method aGetter) throws BeanTableModelException {
        String baseName = aGetter.getName();
        if (baseName.startsWith(IS_PREFIX)) {
            baseName = baseName.replaceFirst(IS_PREFIX, EMPTY_STR);
        } else if (baseName.startsWith(GET_PREFIX)) {
            baseName = baseName.replaceFirst(GET_PREFIX, EMPTY_STR);
        }
        Class<?> propType = aGetter.getReturnType();
        Method setter = null;
        try {
            setter = aClazz.getMethod(SET_PREFIX + baseName, propType);
        }
        catch (SecurityException e) {
            throw new BeanTableModelException("Failed to find setter: set" + baseName + "(" + propType.getName() + ")", e);
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        return setter;
    }

    public static final Method getSetter(Class<?> aClazz, Method aGetter, Class<?> aParameters) {
        String baseName = aGetter.getName();
        if (baseName.startsWith(IS_PREFIX)) {
            baseName = baseName.replaceFirst(IS_PREFIX, EMPTY_STR);
        } else if (baseName.startsWith(GET_PREFIX)) {
            baseName = baseName.replaceFirst(GET_PREFIX, EMPTY_STR);
        }
        try {
            return aClazz.getMethod(SET_PREFIX + baseName, aParameters);
        }
        catch (Exception aException) {
            logger.debug("failed to find setter for getter '" + aGetter + "' and args type '" + aParameters + "'");
            return null;
        }
    }

    public static boolean isSetter(Method aMethod) {
        boolean lReturn = false;
        if (aMethod.getName().startsWith(SET_PREFIX)) {
            lReturn = true;
        }
        return lReturn;
    }

    public static String getBeanName(Method aMethod) {
        String lReturn = null;
        if (aMethod.getName().startsWith(IS_PREFIX)) {
            lReturn = aMethod.getName().replaceFirst("^is", EMPTY_STR);
        } else if (aMethod.getName().startsWith(GET_PREFIX)) {
            lReturn = aMethod.getName().replaceFirst("^get", EMPTY_STR);
        } else if (aMethod.getName().startsWith(SET_PREFIX)) {
            lReturn = aMethod.getName().replaceFirst("^set", EMPTY_STR);
        }
        return lReturn;
    }
}

