/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.impl;

import java.awt.EventQueue;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.swing.JTable;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.icroco.tablemodel.ABeanTableModel;
import org.icroco.tablemodel.ABeanTableModelProperty;
import org.icroco.tablemodel.BeanTableModelException;
import org.icroco.tablemodel.IBeanTableModel;
import org.icroco.tablemodel.impl.BeanHelper;
import org.icroco.tablemodel.impl.EmptyLock;
import org.icroco.tablemodel.impl.Messages;
import org.icroco.tablemodel.impl.TableModelProperty;
import org.icroco.tablemodel.renderer.ARendererStages;
import org.icroco.tablemodel.renderer.IRendererStage;
import org.icroco.tablemodel.renderer.PipelineTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanTableModel<M>
extends AbstractTableModel
implements IBeanTableModel<M> {
    private static final int BUF_SIZE = 100;
    private static transient Logger logger = LoggerFactory.getLogger(BeanTableModel.class);
    private static final int DEFAULT_LIST_SIZE = 50;
    private static final long serialVersionUID = 1L;
    private final ArrayList<M> array;
    private final HashMap<M, Integer> arrayMap;
    private final ReadWriteLock lock;
    private final Class<M> clazz;
    protected TableModelProperty[] properties;
    private static final transient MessageFormat ERROR_1 = new MessageFormat(Messages.getString("BeanTableModel.1"));
    private static final transient MessageFormat ERROR_2 = new MessageFormat(Messages.getString("BeanTableModel.2"));
    private static final transient MessageFormat ERROR_3 = new MessageFormat(Messages.getString("BeanTableModel.3"));
    private static final transient MessageFormat ERROR_9 = new MessageFormat(Messages.getString("BeanTableModel.9"));
    private static final transient MessageFormat ERROR_10 = new MessageFormat(Messages.getString("BeanTableModel.10"));
    private static final transient MessageFormat ERROR_12 = new MessageFormat(Messages.getString("BeanTableModel.12"));
    private static final transient MessageFormat ERROR_13 = new MessageFormat(Messages.getString("BeanTableModel.13"));
    private static final transient MessageFormat ERROR_14 = new MessageFormat(Messages.getString("BeanTableModel.14"));
    private final List<IRendererStage> globalRenderers = new ArrayList<IRendererStage>();
    final ABeanTableModel options;

    public BeanTableModel(Class<M> aClass) throws BeanTableModelException {
        if (aClass == null) {
            throw new BeanTableModelException(Messages.getString("BeanTableModel.0"));
        }
        this.clazz = aClass;
        this.array = new ArrayList(50);
        this.arrayMap = new HashMap();
        this.options = aClass.getAnnotation(ABeanTableModel.class);
        this.lock = this.options != null && this.options.isTreadSafe() ? new ReentrantReadWriteLock() : new EmptyLock();
    }

    public void parseAnnotation() throws BeanTableModelException {
        try {
            this.readBTMAnnotationType(this.clazz);
            List<TableModelProperty> lProperties = this.readBTMAnnotationMethod(this.clazz);
            Collections.sort(lProperties);
            this.checkSetter(lProperties);
            this.properties = lProperties.toArray(new TableModelProperty[lProperties.size() > 0 ? lProperties.size() - 1 : 0]);
            if (logger.isDebugEnabled()) {
                BeanTableModel.dumpProperties(this, false);
            }
        }
        catch (BeanTableModelException exception) {
            BeanTableModel.dumpProperties(this, true);
            throw exception;
        }
    }

    protected void readBTMAnnotationType(Class<M> clazz) throws BeanTableModelException {
        ARendererStages stages;
        ABeanTableModel annotation = clazz.getAnnotation(ABeanTableModel.class);
        if (annotation != null && annotation.excludeGetters().trim().length() > 0 && annotation.autoAddAllGetters()) {
            logger.warn("ABeanTableModel set on '" + clazz.getName() + "' but autoAddAllGetters is disable");
        }
        if ((stages = clazz.getAnnotation(ARendererStages.class)) != null) {
            int i;
            String[] constructorArgs = stages.stagesParameters();
            Class<? extends IRendererStage>[] clazzStg = stages.stages();
            try {
                for (i = 0; i < clazzStg.length; ++i) {
                    this.globalRenderers.add(clazzStg[i].getConstructor(String.class).newInstance(i < constructorArgs.length ? constructorArgs[i] : ""));
                }
            }
            catch (Exception exception) {
                throw new BeanTableModelException("Failed to install global Renderer: " + ERROR_13.format(new Object[]{clazzStg[i].getName()}), exception);
            }
        }
    }

    protected TableModelProperty createNewProperty() {
        return new TableModelProperty();
    }

    protected List<TableModelProperty> readBTMAnnotationMethod(Class<M> aClazz) throws BeanTableModelException {
        Method[] methods = aClazz.getMethods();
        ArrayList<TableModelProperty> lProperties = new ArrayList<TableModelProperty>(methods.length);
        TableModelProperty search = this.createNewProperty();
        Object[] excludeGetters = this.options == null ? new String[]{} : this.options.excludeGetters().split(",");
        for (int i = 0; i < excludeGetters.length; ++i) {
            excludeGetters[i] = ((String)excludeGetters[i]).trim();
        }
        Arrays.sort(excludeGetters);
        try {
            for (Method method : methods) {
                TableModelProperty prop;
                int idx;
                String found;
                ABeanTableModelProperty aProp = method.getAnnotation(ABeanTableModelProperty.class);
                if (this.isAutoDiscoverGetter() && BeanHelper.matchGetter(method) && Arrays.binarySearch(excludeGetters, method.getName()) < 0) {
                    search.name = found = BeanHelper.getBeanName(method);
                    idx = lProperties.indexOf(search);
                    TableModelProperty tableModelProperty = prop = idx < 0 ? this.createNewProperty() : (TableModelProperty)lProperties.get(idx);
                    if (idx < 0 || BeanTableModel.equalsMethod(((TableModelProperty)lProperties.get((int)idx)).getter, method)) {
                        prop.name = found;
                        prop.label = found;
                        prop.isEditable = false;
                        prop.columnClass = method.getReturnType();
                        prop.orderKey = found;
                        prop.getter = method;
                        if (idx < 0) {
                            lProperties.add(prop);
                        }
                        this.readRSAnnotationMethod(prop, method);
                    } else {
                        throw new BeanTableModelException(ERROR_1.format(new Object[]{found}));
                    }
                }
                if (aProp == null) continue;
                if (BeanHelper.isGetter(method)) {
                    search.name = found = aProp.name() == null ? BeanHelper.getBeanName(method) : aProp.name();
                    idx = lProperties.indexOf(search);
                    TableModelProperty tableModelProperty = prop = idx < 0 ? this.createNewProperty() : (TableModelProperty)lProperties.get(idx);
                    if (idx < 0 || BeanTableModel.equalsMethod(((TableModelProperty)lProperties.get((int)idx)).getter, method)) {
                        prop.name = found;
                        prop.label = found;
                        prop.isEditable = aProp.isEditable();
                        prop.columnClass = method.getReturnType();
                        prop.orderKey = aProp.orderKey();
                        prop.getter = method;
                        Method setter = BeanHelper.checkSetter(aClazz, method);
                        if (setter != null) {
                            prop.setter = setter;
                        }
                        if (idx < 0) {
                            lProperties.add(prop);
                        }
                        this.readRSAnnotationMethod(prop, method);
                        continue;
                    }
                    throw new BeanTableModelException(ERROR_1.format(new Object[]{found}));
                }
                throw new BeanTableModelException(ERROR_12.format(new Object[0]));
            }
        }
        catch (BeanTableModelException exception) {
            try {
                throw exception;
            }
            catch (Throwable throwable) {
                Collections.sort(lProperties);
                this.properties = lProperties.toArray(new TableModelProperty[lProperties.size() > 0 ? lProperties.size() - 1 : 0]);
                throw throwable;
            }
        }
        Collections.sort(lProperties);
        this.properties = lProperties.toArray(new TableModelProperty[lProperties.size() > 0 ? lProperties.size() - 1 : 0]);
        return lProperties;
    }

    private static final boolean equalsMethod(Method aMethod1, Method aMethod2) {
        if (!aMethod1.getName().equals(aMethod2.getName())) {
            return false;
        }
        return Arrays.equals(aMethod1.getParameterTypes(), aMethod2.getParameterTypes());
    }

    private boolean isAutoDiscoverGetter() {
        return this.options != null && this.options.autoAddAllGetters();
    }

    private final void readRSAnnotationMethod(TableModelProperty aProp, Method aMethod) {
        ARendererStages stages = aMethod.getAnnotation(ARendererStages.class);
        ArrayList<IRendererStage> res = new ArrayList<IRendererStage>(this.globalRenderers);
        if (stages != null) {
            try {
                if (!stages.tableCellRenderer().equals(TableCellRenderer.class)) {
                    aProp.tableRenderer = stages.tableCellRenderer().newInstance();
                }
            }
            catch (Exception aException) {
                throw new BeanTableModelException(ERROR_14.format(new Object[]{stages.tableCellRenderer()}), aException);
            }
            try {
                String[] constructorArgs = stages.stagesParameters();
                Class<? extends IRendererStage>[] clazzStg = stages.stages();
                for (int i = 0; i < clazzStg.length; ++i) {
                    res.add(clazzStg[i].getConstructor(String.class).newInstance(i < constructorArgs.length ? constructorArgs[i] : ""));
                }
            }
            catch (Exception exception) {
                throw new BeanTableModelException(ERROR_13.format(new Object[]{aProp.toString()}), exception);
            }
        }
        aProp.renderers = res.toArray(new IRendererStage[0]);
    }

    public void installRenderer(JTable aTable) {
        if (aTable == null) {
            logger.debug("installRenderer a null JTable parameter, we skip installation.");
            return;
        }
        int i = 0;
        for (TableModelProperty prop : this.properties) {
            if (prop.tableRenderer != null) {
                aTable.getColumnModel().getColumn(i).setCellRenderer(prop.tableRenderer);
            }
            if (prop.renderers != null && prop.renderers.length > 0) {
                TableCellRenderer oldRenderer = null;
                oldRenderer = aTable.getCellRenderer(0, i);
                if (oldRenderer == null) {
                    oldRenderer = aTable.getDefaultRenderer(this.getColumnClass(i));
                }
                aTable.getColumnModel().getColumn(i).setCellRenderer(new PipelineTableCellRenderer(prop.tableRenderer != null ? prop.tableRenderer : this.cloneExisitingRenderer(oldRenderer), prop.renderers));
            }
            ++i;
        }
    }

    protected final TableCellRenderer cloneExisitingRenderer(TableCellRenderer aOldRenderer) {
        TableCellRenderer value = aOldRenderer;
        if (aOldRenderer == null) {
            return new DefaultTableCellRenderer();
        }
        try {
            value = (TableCellRenderer)aOldRenderer.getClass().newInstance();
        }
        catch (InstantiationException aException) {
            logger.warn("Technical error: Failed to instanciate " + aOldRenderer.getClass().getName() + " we return current instance: " + aOldRenderer.hashCode(), (Throwable)aException);
        }
        catch (IllegalAccessException aException) {
            try {
                Constructor<?> constructor = aOldRenderer.getClass().getConstructor(new Class[0]);
                constructor.setAccessible(true);
                value = (TableCellRenderer)constructor.newInstance(new Object[0]);
            }
            catch (Throwable aException1) {
                logger.warn("Technical error: Failed to change constructor visibilty " + aOldRenderer.getClass().getName() + " we return current instance: " + aOldRenderer.hashCode(), (Throwable)aException);
                value = aOldRenderer;
            }
        }
        return value;
    }

    private void checkSetter(List<TableModelProperty> aProperties) throws BeanTableModelException {
        for (TableModelProperty prop : aProperties) {
            if (prop.getter == null) {
                throw new BeanTableModelException(ERROR_3.format(new Object[]{prop.name}));
            }
            if (!prop.isEditable || prop.setter != null) continue;
            throw new BeanTableModelException(ERROR_2.format(new Object[]{prop.name, prop.getter.getName()}));
        }
    }

    @Override
    public int getColumnCount() {
        return this.properties.length;
    }

    @Override
    public int getRowCount() {
        return this.array.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        Object lReturn = null;
        try {
            this.lock.readLock().lock();
            lReturn = this.properties[columnIndex].getter.invoke(this.array.get(rowIndex), (Object[])null);
        }
        catch (IllegalArgumentException aException) {
            logger.error(ERROR_9.format(new Object[]{this.properties[columnIndex].name, rowIndex, columnIndex}), (Throwable)aException);
        }
        catch (IllegalAccessException aException) {
            logger.error(ERROR_9.format(new Object[]{this.properties[columnIndex].name, rowIndex, columnIndex}), (Throwable)aException);
        }
        catch (InvocationTargetException aException) {
            logger.error(ERROR_9.format(new Object[]{this.properties[columnIndex].name, rowIndex, columnIndex}), (Throwable)aException);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return lReturn;
    }

    @Override
    public Class<?> getColumnClass(int aColumnIndex) {
        return this.properties[aColumnIndex].getter.getReturnType();
    }

    @Override
    public String getColumnName(int aColumn) {
        return this.properties[aColumn].label;
    }

    @Override
    public boolean isCellEditable(int aRowIndex, int aColumnIndex) {
        return this.properties[aColumnIndex].isEditable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setValueAt(Object aValue, int aRowIndex, int aColumnIndex) {
        try {
            if (!EventQueue.isDispatchThread()) {
                throw new IllegalAccessException("Can not call setValueAt from another thread that EDT. Calling thread is: " + Thread.currentThread().getName());
            }
            this.lock.writeLock().lock();
            int modelColIdx = aColumnIndex;
            int modelRowIdx = aRowIndex;
            M toto = this.array.get(modelRowIdx);
            this.properties[modelColIdx].setter.invoke(toto, aValue);
            this.fireBeanTableCellUpdated(aRowIndex, aColumnIndex);
        }
        catch (IllegalArgumentException aException) {
            logger.error(ERROR_10.format(new Object[]{this.properties[aRowIndex].name, aRowIndex, aColumnIndex, aValue, this.properties[aColumnIndex].columnClass.getSimpleName(), aValue.getClass().getSimpleName()}), (Throwable)aException);
        }
        catch (IllegalAccessException aException) {
            logger.error(ERROR_10.format(new Object[]{this.properties[aRowIndex].name, aRowIndex, aColumnIndex, aValue, this.properties[aColumnIndex].columnClass.getSimpleName(), aValue.getClass().getSimpleName()}), (Throwable)aException);
        }
        catch (InvocationTargetException aException) {
            logger.error(ERROR_10.format(new Object[]{this.properties[aRowIndex].name, aRowIndex, aColumnIndex, aValue, this.properties[aColumnIndex].columnClass.getSimpleName(), aValue.getClass().getSimpleName()}), (Throwable)aException);
        }
        catch (NullPointerException aException) {
            logger.error(ERROR_10.format(new Object[]{this.properties[aRowIndex].name, aRowIndex, aColumnIndex, aValue, this.properties[aColumnIndex].columnClass.getSimpleName(), aValue.getClass().getSimpleName()}), (Throwable)aException);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final M getValueAt(int rowIndex) {
        try {
            this.lock.readLock().lock();
            if (rowIndex >= 0 && rowIndex < this.array.size()) {
                M m = this.array.get(rowIndex);
                return m;
            }
        }
        finally {
            this.lock.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final int getIdxFor(M aValue) {
        try {
            this.lock.readLock().lock();
            int n = this.arrayMap.get(aValue);
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    @Override
    public final M getValueAt(M aRow) {
        Integer value = this.getIdxFor(aRow);
        return (M)(value == null ? null : (Object)this.getValueAt((M)value));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean add(M aValue) {
        try {
            this.lock.writeLock().lock();
            if (this.arrayMap.containsKey(aValue)) {
                boolean bl = false;
                return bl;
            }
            if (this.array.add(aValue)) {
                this.arrayMap.put(aValue, this.array.size() - 1);
                this.fireBeanTableRowsInserted(this.array.size() - 1, this.array.size() - 1);
                boolean bl = true;
                return bl;
            }
            logger.error("Failed to insert data at index:'" + this.array.size() + "', value: " + aValue);
            boolean bl = false;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void fireBeanTableRowsInserted(int aFirstRow, int aLastRow) {
        this.fireTableRowsInserted(aFirstRow, aLastRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addOrUpdateRow(M aValue) {
        try {
            this.lock.writeLock().lock();
            Integer idx = this.arrayMap.get(aValue);
            if (idx == null) {
                boolean bl = this.add(aValue);
                return bl;
            }
            this.array.set(idx, aValue);
            this.fireBeanTableRowsUpdated(idx, idx);
            boolean bl = true;
            return bl;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected void fireBeanTableRowsUpdated(int aFirstRow, int aLastRow) {
        this.fireTableRowsUpdated(aFirstRow, aLastRow);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void updateRow(Object aValue, M aRowKey, int aCol) {
        try {
            this.lock.writeLock().lock();
            Integer row = this.arrayMap.get(aRowKey);
            if (row != null) {
                this.updateRow(aValue, row, aCol);
            } else if (logger.isDebugEnabled()) {
                logger.debug("Row not found: " + aRowKey);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final M updateRow(Object aValue, int aRowIndex, int aColumnIndex) {
        try {
            this.lock.writeLock().lock();
            M record = this.array.get(aRowIndex);
            if (this.properties[aColumnIndex].setter == null) {
                Method setter = BeanHelper.getSetter(this.clazz, this.properties[aColumnIndex].getter, aValue.getClass());
                if (setter == null) {
                    throw new IllegalAccessException("Failed to find setter corresponding to getter " + this.properties[aColumnIndex].getter.getName() + " , check if parameter type is not a primitive type");
                }
                setter.invoke(record, aValue);
                this.fireBeanTableCellUpdated(aRowIndex, aColumnIndex);
            } else {
                this.properties[aColumnIndex].setter.invoke(record, aValue);
                this.fireBeanTableCellUpdated(aRowIndex, aColumnIndex);
            }
            M m = record;
            return m;
        }
        catch (IllegalArgumentException aException) {
            logger.error(ERROR_10.format(new Object[]{this.properties[aColumnIndex].name, aRowIndex, aColumnIndex, aValue, this.properties[aColumnIndex].columnClass.getSimpleName(), aValue.getClass().getSimpleName()}), (Throwable)aException);
        }
        catch (IllegalAccessException aException) {
            logger.error(ERROR_10.format(new Object[]{this.properties[aColumnIndex].name, aRowIndex, aColumnIndex, aValue, this.properties[aColumnIndex].columnClass.getSimpleName(), aValue.getClass().getSimpleName()}), (Throwable)aException);
        }
        catch (InvocationTargetException aException) {
            logger.error(ERROR_10.format(new Object[]{this.properties[aColumnIndex].name, aRowIndex, aColumnIndex, aValue, this.properties[aColumnIndex].columnClass.getSimpleName(), aValue.getClass().getSimpleName()}), (Throwable)aException);
        }
        catch (NullPointerException aException) {
            logger.error(ERROR_10.format(new Object[]{this.properties[aColumnIndex].name, aRowIndex, aColumnIndex, aValue, this.properties[aColumnIndex].columnClass.getSimpleName(), aValue.getClass().getSimpleName()}), (Throwable)aException);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return null;
    }

    protected void fireBeanTableCellUpdated(int aRow, int aColumn) {
        this.fireTableCellUpdated(aRow, aColumn);
    }

    protected static void dumpProperties(BeanTableModel<?> model, boolean error) {
        if (model != null) {
            StringBuilder buffer = new StringBuilder(100);
            buffer.append("Current Status: " + (model.clazz == null ? "null" : model.clazz.getName()) + "\n");
            int index = 0;
            if (model.properties != null) {
                for (TableModelProperty prop : model.properties) {
                    buffer.append("  * col=" + index++ + " " + prop.toString() + "\n");
                }
            }
            if (error) {
                logger.error(buffer.toString());
            } else {
                logger.debug(buffer.toString());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        try {
            this.lock.writeLock().lock();
            this.array.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset(Collection<M> collection) {
        try {
            this.lock.writeLock().lock();
            this.array.clear();
            this.array.addAll(collection);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.fireTableDataChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public M deleteRow(M aValue) {
        try {
            this.lock.writeLock().lock();
            Integer idx = this.arrayMap.get(aValue);
            if (idx != null) {
                M m = this.deleteRowAt(idx);
                return m;
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public M deleteRowAt(int aIdx) {
        M remove = null;
        try {
            this.lock.writeLock().lock();
            if (aIdx >= this.array.size()) {
                M m = null;
                return m;
            }
            remove = this.array.get(aIdx);
            if (remove != null) {
                this.array.remove(aIdx);
                this.arrayMap.remove(remove);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.fireTableRowsDeleted(aIdx, aIdx);
        return remove;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int deleteRows(int aStartIdx, int aEndIdx) {
        if (aStartIdx >= 0) {
            int i;
            int end = Math.min(this.array.size() - 1, aEndIdx);
            try {
                this.lock.writeLock().lock();
                for (i = aStartIdx; i <= end; ++i) {
                    this.arrayMap.remove(this.array.get(i));
                }
                for (int j = i - 1; j >= aStartIdx; --j) {
                    this.array.remove(j);
                }
            }
            finally {
                this.lock.writeLock().unlock();
            }
            this.fireTableRowsDeleted(aStartIdx, end);
            return i - aStartIdx;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int[] deleteRows(int ... aIdx) {
        ArrayList<Integer> removed = new ArrayList<Integer>();
        int[] newIdx = Arrays.copyOf(aIdx, aIdx.length);
        Arrays.sort(newIdx);
        try {
            this.lock.writeLock().lock();
            for (int i = newIdx.length - 1; i >= 0; --i) {
                M value;
                if (newIdx[i] >= this.array.size() || (value = this.array.remove(newIdx[i])) == null) continue;
                this.arrayMap.remove(value);
                removed.add(newIdx[i]);
                this.fireTableRowsDeleted(newIdx[i], newIdx[i]);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        Collections.sort(removed);
        int[] lReturn = new int[removed.size()];
        for (int i = 0; i < removed.size(); ++i) {
            lReturn[i] = (Integer)removed.get(i);
        }
        return lReturn;
    }

    @Override
    public List<M> getValues() {
        return Collections.unmodifiableList(this.array);
    }
}

