/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.impl.blinking;

import java.awt.Color;
import javax.swing.JTable;
import javax.swing.event.TableModelEvent;
import org.icroco.tablemodel.impl.blinking.CellFlasher;
import org.icroco.tablemodel.impl.blinking.IFlashListener;

final class AnimatedCellFlasher
extends CellFlasher {
    static final int animatedStep = 20;
    static final int ANIM_UP = 0;
    static final int ANIM_DOWN = 1;
    int maxAge;
    int curAge;
    int animWay;
    int upMax;

    public AnimatedCellFlasher(JTable table, int maxFlashes, int flashInterval, IFlashListener listener, int row, int col, Long aKey) {
        super(table, 20, flashInterval / 20, listener, row, col, aKey);
        this.maxAge = 20;
        this.upMax = 8;
        this.curAge = 0;
        this.animWay = 0;
        this.isFlashOn = true;
    }

    public AnimatedCellFlasher(IFlashListener listener) {
        super(listener);
    }

    @Override
    protected void init(JTable table, int maxFlashes, int flashInterval, int row, int col, Long key) {
        super.init(table, maxFlashes, flashInterval, key);
        this.maxAge = 20;
        this.curAge = 0;
    }

    @Override
    public void doFlash() {
        ++this.curAge;
        TableModelEvent event = new TableModelEvent(this.table.getModel(), this.row, this.row, this.col);
        this.flash(event);
    }

    @Override
    protected void flash(TableModelEvent event) {
        --this.numberOfFlashes;
        if (this.numberOfFlashes <= 0) {
            this.isFlashOn = false;
        }
        this.table.tableChanged(event);
        if (this.isDoneFlashing()) {
            this.stopFlash();
        }
    }

    public Color getGradient(Color aNormal, Color aFlash) {
        return aNormal == null ? aFlash : AnimatedCellFlasher.mix(aFlash, aNormal, this.getCoef((float)this.curAge / (float)this.maxAge));
    }

    final float getCoef(float x) {
        return -x + 1.0f;
    }

    static final float getCoefUp(float x, int ajust) {
        return (float)ajust * x;
    }

    static final float getCoefDown(float x, int ajust) {
        return (float)(-(ajust / (ajust - 1))) * x + 1.0f + (float)(1 / ajust);
    }

    private static final Color mix(Color normal, Color color, float pos) {
        pos = Math.min(1.0f, pos);
        float npos = 1.0f - pos;
        int r = (int)((float)normal.getRed() * pos + npos * (float)color.getRed());
        int g = (int)((float)normal.getGreen() * pos + npos * (float)color.getGreen());
        int b = (int)((float)normal.getBlue() * pos + npos * (float)color.getBlue());
        r = Math.max(0, Math.min(255, r));
        g = Math.max(0, Math.min(255, g));
        b = Math.max(0, Math.min(255, b));
        return new Color(r, g, b);
    }
}

