/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.impl.blinking;

import java.awt.Color;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import org.icroco.tablemodel.BeanTableModelException;
import org.icroco.tablemodel.blinking.ABlinking;
import org.icroco.tablemodel.blinking.EBlinkingMode;
import org.icroco.tablemodel.blinking.IBlinkTableModel;
import org.icroco.tablemodel.impl.BeanTableModel;
import org.icroco.tablemodel.impl.TableModelProperty;
import org.icroco.tablemodel.impl.blinking.AbstractBlinhRendererStage;
import org.icroco.tablemodel.impl.blinking.BlinkAnimatedColorRendererStage;
import org.icroco.tablemodel.impl.blinking.BlinkBorderRendererStage;
import org.icroco.tablemodel.impl.blinking.BlinkColorRendererStage;
import org.icroco.tablemodel.impl.blinking.BlinkFontRendererStage;
import org.icroco.tablemodel.impl.blinking.TableFlasher;
import org.icroco.tablemodel.impl.blinking.TableModelBlinkProperty;
import org.icroco.tablemodel.renderer.PipelineTableCellRenderer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BeanBlinkTableModel<M>
extends BeanTableModel<M>
implements IBlinkTableModel<M> {
    private EBlinkingMode defaultMode = EBlinkingMode.ANIMATED_BG_COLOR;
    private Color defaultFgColor = null;
    private Color defaultBgColor = Color.decode("#FF9999");
    private int defaultDuration = 500;
    private int defaultRepeat = 1;
    private boolean autoBlinkingForAll = false;
    private static final long serialVersionUID = 1L;
    private static transient Logger logger = LoggerFactory.getLogger(BeanBlinkTableModel.class);
    final TableFlasher flasher;

    public BeanBlinkTableModel(JTable aTable, Class<M> aClass) throws BeanTableModelException {
        super(aClass);
        this.flasher = new TableFlasher(aTable);
    }

    @Override
    protected TableModelProperty createNewProperty() {
        return new TableModelBlinkProperty();
    }

    @Override
    protected void readBTMAnnotationType(Class<M> aClazz) throws BeanTableModelException {
        super.readBTMAnnotationType(aClazz);
        this.readBBTMAnnotationType(aClazz);
    }

    protected void readBBTMAnnotationType(Class<M> aClazz) {
        ABlinking annotation = aClazz.getAnnotation(ABlinking.class);
        if (annotation != null) {
            if (annotation.mode() != EBlinkingMode.DEFAULT) {
                this.defaultMode = annotation.mode();
            }
            if (!annotation.bgColor().equalsIgnoreCase("default")) {
                this.defaultBgColor = Color.decode(annotation.bgColor());
            }
            if (!annotation.fgColor().equalsIgnoreCase("default")) {
                this.defaultFgColor = Color.decode(annotation.fgColor());
            }
            if (annotation.duration() > 0) {
                this.defaultDuration = annotation.duration();
            }
            if (annotation.repeat() > 0) {
                this.defaultRepeat = annotation.repeat();
            }
            this.autoBlinkingForAll = annotation.autoAddAllSetters();
        }
    }

    @Override
    protected List<TableModelProperty> readBTMAnnotationMethod(Class<M> aClazz) throws BeanTableModelException {
        List<TableModelProperty> props = super.readBTMAnnotationMethod(aClazz);
        this.readBBTMAnnotationMethod(props);
        return props;
    }

    private final void readBBTMAnnotationMethod(List<TableModelProperty> aProps) {
        int i = -1;
        for (TableModelProperty prop : aProps) {
            ++i;
            TableModelBlinkProperty bProp = (TableModelBlinkProperty)prop;
            Method setter = bProp.getSetter();
            if (setter == null) continue;
            ABlinking blinkAnnotation = setter.getAnnotation(ABlinking.class);
            if (this.autoBlinkingForAll) {
                // empty if block
            }
            if (blinkAnnotation == null) continue;
            bProp.setBlink(true);
            bProp.setMode(blinkAnnotation.mode() == EBlinkingMode.DEFAULT ? this.defaultMode : blinkAnnotation.mode());
            bProp.setDuration(blinkAnnotation.duration() <= 0 ? this.defaultDuration : blinkAnnotation.duration());
            bProp.setRepeat(blinkAnnotation.repeat() <= 0 ? this.defaultRepeat : blinkAnnotation.repeat());
            bProp.setBlinkBgColor(blinkAnnotation.bgColor().equalsIgnoreCase("default") ? this.defaultBgColor : Color.decode(blinkAnnotation.bgColor()));
            bProp.setBlinkFgColor(blinkAnnotation.fgColor().equalsIgnoreCase("default") ? this.defaultFgColor : Color.decode(blinkAnnotation.fgColor()));
        }
    }

    @Override
    public void setGlobalDuration(final int aDurationInMs) {
        try {
            if (SwingUtilities.isEventDispatchThread()) {
                for (TableModelProperty prop : this.properties) {
                    TableModelBlinkProperty bProp = (TableModelBlinkProperty)prop;
                    bProp.setDuration(aDurationInMs);
                }
            } else {
                SwingUtilities.invokeAndWait(new Runnable(){

                    @Override
                    public void run() {
                        for (TableModelProperty prop : BeanBlinkTableModel.this.properties) {
                            TableModelBlinkProperty bProp = (TableModelBlinkProperty)prop;
                            bProp.setDuration(aDurationInMs);
                        }
                    }
                });
            }
        }
        catch (InterruptedException aException) {
            aException.printStackTrace();
        }
        catch (InvocationTargetException aException) {
            aException.printStackTrace();
        }
    }

    final void installRenderer() {
        super.installRenderer(this.flasher.getTable());
        int i = -1;
        for (TableModelProperty prop : this.properties) {
            ++i;
            TableModelBlinkProperty bProp = (TableModelBlinkProperty)prop;
            JTable table = this.flasher.getTable();
            if (!bProp.isBlink()) continue;
            TableCellRenderer oldRenderer = null;
            oldRenderer = table.getCellRenderer(0, i);
            if (oldRenderer == null) {
                oldRenderer = table.getDefaultRenderer(this.getColumnClass(i));
            }
            AbstractBlinhRendererStage blinkStage = null;
            switch (bProp.getMode()) {
                case ANIMATED_BG_COLOR: {
                    blinkStage = new BlinkAnimatedColorRendererStage(this.flasher, bProp.getBlinkBgColor(), bProp.getBlinkFgColor());
                    break;
                }
                case COLOR: {
                    blinkStage = new BlinkColorRendererStage(this.flasher, bProp.getBlinkBgColor(), bProp.getBlinkFgColor());
                    break;
                }
                case BORDER: {
                    blinkStage = new BlinkBorderRendererStage(this.flasher, bProp.getBlinkBgColor());
                    break;
                }
                case FONT: {
                    blinkStage = new BlinkFontRendererStage(this.flasher, bProp.getBlinkFgColor());
                    break;
                }
                default: {
                    logger.error("unknown blinking mode: " + (Object)((Object)bProp.getMode()));
                }
            }
            if (blinkStage == null) continue;
            PipelineTableCellRenderer newRenderer = null;
            if (oldRenderer instanceof PipelineTableCellRenderer) {
                ((PipelineTableCellRenderer)oldRenderer).addStage(blinkStage);
                continue;
            }
            newRenderer = new PipelineTableCellRenderer(oldRenderer, blinkStage);
            table.getColumnModel().getColumn(i).setCellRenderer(newRenderer);
        }
    }

    @Override
    protected void fireBeanTableCellUpdated(int aRow, int aColumn) {
        TableModelBlinkProperty prop = (TableModelBlinkProperty)this.properties[aColumn];
        if (prop.isBlink()) {
            this.flasher.flashCell(aRow, aColumn, prop.getRepeat(), prop.getDuration(), prop.getMode());
        } else {
            this.fireTableCellUpdated(aRow, aColumn);
        }
    }
}

