/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.impl.blinking;

import java.awt.Color;
import java.awt.Component;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import org.icroco.tablemodel.blinking.CellFlashProvider;
import org.icroco.tablemodel.impl.blinking.AbstractBlinhRendererStage;

public class BlinkBorderRendererStage
extends AbstractBlinhRendererStage {
    protected final Border raised;
    protected static final Border noFocusBorder = new EmptyBorder(1, 1, 1, 1);
    protected static final Border focusBorder = UIManager.getBorder("Table.focusCellHighlightBorder");

    public BlinkBorderRendererStage(CellFlashProvider aProvider, Color aBorderColor) {
        super(aProvider);
        this.raised = BorderFactory.createLineBorder(aBorderColor);
    }

    public BlinkBorderRendererStage(CellFlashProvider aProvider) {
        this(aProvider, Color.decode("#FF9999"));
    }

    @Override
    public void render(Component aRendered, JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        int mCol = aTable.convertColumnIndexToModel(aColumn);
        int mRow = aTable.convertRowIndexToModel(aRow);
        JComponent jc = (JComponent)aRendered;
        if (jc instanceof AbstractButton) {
            ((AbstractButton)jc).setBorderPainted(true);
        }
        if (this.provider.isFlashOn(mRow, mCol)) {
            jc.setBorder(this.raised);
        } else if (aHasFocus) {
            jc.setBorder(focusBorder);
        } else {
            jc.setBorder(noFocusBorder);
        }
    }
}

