/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.impl.blinking;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JTable;
import javax.swing.Timer;
import javax.swing.event.TableModelEvent;
import org.icroco.tablemodel.impl.blinking.IFlashListener;

abstract class Flasher
implements ActionListener {
    protected int numberOfFlashes;
    protected boolean isFlashOn;
    protected Timer timer;
    protected IFlashListener listener;
    protected JTable table;
    protected Long key;

    public Flasher(JTable aTable, int aMaxFlashes, int aFlashInterval, IFlashListener aListener, Long aKey) {
        this.table = aTable;
        this.numberOfFlashes = aMaxFlashes + 1;
        this.isFlashOn = false;
        this.listener = aListener;
        this.key = aKey;
        this.timer = new Timer(aFlashInterval, this);
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        this.listener.onFlash(this);
    }

    public Flasher(IFlashListener aListener) {
        this.isFlashOn = true;
        this.listener = aListener;
        this.timer = new Timer(1000, this);
        this.timer.setInitialDelay(0);
        this.timer.setRepeats(true);
        this.listener.onFlash(this);
    }

    protected void init(JTable aTable, int aMaxFlashes, int aFlashInterval, Long aKey) {
        this.table = aTable;
        this.numberOfFlashes = aMaxFlashes + 1;
        this.isFlashOn = false;
        this.key = aKey;
        this.timer.setInitialDelay(0);
        this.timer.setDelay(aFlashInterval);
        this.listener.onFlash(this);
    }

    @Override
    public void actionPerformed(ActionEvent aE) {
        this.doFlash();
    }

    public boolean isDoneFlashing() {
        return this.numberOfFlashes == 0;
    }

    public void startFlash() {
        this.timer.start();
    }

    public void stopFlash() {
        this.timer.stop();
        this.listener.onFlashDone(this);
    }

    public boolean isFlashOn() {
        return this.isFlashOn;
    }

    protected void flash(TableModelEvent event) {
        boolean bl = this.isFlashOn = !this.isFlashOn;
        if (this.isFlashOn) {
            --this.numberOfFlashes;
        }
        this.table.tableChanged(event);
        if (this.isDoneFlashing()) {
            this.stopFlash();
        }
    }

    public abstract void doFlash();

    public Long getKey() {
        return this.key;
    }
}

