/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.impl.blinking;

import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.JTable;
import javax.swing.JViewport;
import org.icroco.tablemodel.blinking.CellFlashProvider;
import org.icroco.tablemodel.blinking.EBlinkingMode;
import org.icroco.tablemodel.impl.blinking.AnimatedCellFlasher;
import org.icroco.tablemodel.impl.blinking.CellFlasher;
import org.icroco.tablemodel.impl.blinking.Flasher;
import org.icroco.tablemodel.impl.blinking.IFlashListener;
import org.icroco.tablemodel.impl.blinking.RowFlasher;

public final class TableFlasher
implements CellFlashProvider,
IFlashListener {
    public static final int MAX_FLASHES = 1;
    public static final int STD_FLASH_INTERVAL = 1000;
    private final ReentrantLock lock = new ReentrantLock();
    private final Map<Long, Flasher> flashers;
    private final JTable table;

    public TableFlasher(JTable table) {
        this.table = table;
        this.flashers = new HashMap<Long, Flasher>();
    }

    JTable getTable() {
        return this.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isFlashOn(int row, int column) {
        try {
            this.lock.lock();
            if (this.flashers.isEmpty()) {
                boolean bl = false;
                return bl;
            }
            boolean bl = TableFlasher.isFlasherOn(this.getCellFlasher(row, column));
            return bl;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object getFlashOn(int row, int column) {
        try {
            this.lock.lock();
            if (this.flashers.isEmpty()) {
                Object var3_3 = null;
                return var3_3;
            }
            CellFlasher cell = this.getCellFlasher(row, column);
            CellFlasher cellFlasher = TableFlasher.isFlasherOn(cell) ? cell : null;
            return cellFlasher;
        }
        finally {
            this.lock.unlock();
        }
    }

    public final void flashCell(int row, int col) {
        this.flashCell(row, col, 1, 1000, EBlinkingMode.ANIMATED_BG_COLOR);
    }

    public final void flashCell(int row, int col, int maxNumberOfFlashes, int flashInterval, EBlinkingMode aBlinkingMode) {
        if (TableFlasher.isCellVisible(this.table, row, col)) {
            Long key = TableFlasher.constructLongKey(row, col);
            CellFlasher f = aBlinkingMode == EBlinkingMode.ANIMATED_BG_COLOR ? new AnimatedCellFlasher(this.table, maxNumberOfFlashes, flashInterval, this, row, col, key) : new CellFlasher(this.table, maxNumberOfFlashes, flashInterval, this, row, col, key);
        }
    }

    private static final boolean isCellVisible(JTable aTable, int aRowIndex, int aColIndex) {
        if (aTable == null || !(aTable.getParent() instanceof JViewport)) {
            return false;
        }
        JViewport viewport = (JViewport)aTable.getParent();
        int aViewRow = aTable.convertRowIndexToView(aRowIndex);
        int aViewCol = aTable.convertColumnIndexToView(aColIndex);
        Rectangle rect = aTable.getCellRect(aViewRow, aViewCol, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        return new Rectangle(viewport.getExtentSize()).intersects(rect);
    }

    public void flashRow(int row) {
        this.flashRow(row, 1, 1000);
    }

    public void flashRow(int row, int maxNumberOfFlashes, int flashInterval) {
        Long key = TableFlasher.constructLongKey(row);
        RowFlasher f = new RowFlasher(this.table, maxNumberOfFlashes, flashInterval, this, row, key);
        this.addFlasher(key, f);
    }

    public void clearCellFlash(int row, int col) {
        CellFlasher f = this.getCellFlasher(row, col);
        if (f != null) {
            f.stopFlash();
            System.out.println("clearCellFlash: " + Thread.currentThread().getName());
        }
    }

    public void clearRowFlash(int row) {
        RowFlasher f = this.getRowFlasher(row);
        if (f != null) {
            f.stopFlash();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAllFlashers() {
        try {
            this.lock.lock();
            for (Flasher oneFlasher : this.flashers.values()) {
                oneFlasher.stopFlash();
            }
            this.flashers.clear();
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addFlasher(Long key, Flasher f) {
        try {
            this.lock.lock();
            Flasher old = this.flashers.get(key);
            if (old != null) {
                old.stopFlash();
            }
            this.flashers.put(key, f);
        }
        finally {
            this.lock.unlock();
        }
        f.startFlash();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final CellFlasher getCellFlasher(int row, int col) {
        Long key = TableFlasher.constructLongKey(row, col);
        try {
            CellFlasher f;
            this.lock.lock();
            CellFlasher cellFlasher = f = (CellFlasher)this.flashers.get(key);
            return cellFlasher;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RowFlasher getRowFlasher(int row) {
        Long key = TableFlasher.constructLongKey(row);
        try {
            RowFlasher f;
            this.lock.lock();
            RowFlasher rowFlasher = f = (RowFlasher)this.flashers.get(key);
            return rowFlasher;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFlasher(Object key) {
        try {
            this.lock.lock();
            this.flashers.remove(key);
        }
        finally {
            this.lock.unlock();
        }
    }

    protected static boolean isFlasherOn(Flasher f) {
        return f != null && !f.isDoneFlashing() && f.isFlashOn();
    }

    static final Long constructLongKey(int row, int col) {
        long lReturn = col;
        lReturn <<= 32;
        return lReturn |= (long)row;
    }

    public static final Long constructLongKey(int row) {
        return TableFlasher.constructLongKey(row, -1);
    }

    public static final int getRow(Long aValue) {
        return (int)aValue.longValue();
    }

    public static final int getCol(Long aValue) {
        return (int)(aValue >> 32);
    }

    public static void main(String[] args) {
        Long value = TableFlasher.constructLongKey(50, 12);
        System.out.println("row:" + TableFlasher.getRow(value) + " col:" + TableFlasher.getCol(value));
        value = TableFlasher.constructLongKey(Integer.MAX_VALUE, 12);
        System.out.println("row:" + TableFlasher.getRow(value) + "=" + Integer.MAX_VALUE + " col:" + TableFlasher.getCol(value));
        value = TableFlasher.constructLongKey(Integer.MAX_VALUE, Integer.MAX_VALUE);
        System.out.println("row:" + TableFlasher.getRow(value) + "=" + Integer.MAX_VALUE + " col:" + TableFlasher.getCol(value) + "=" + Integer.MAX_VALUE);
        value = TableFlasher.constructLongKey(60);
        System.out.println("row:" + TableFlasher.getRow(value) + " col:" + TableFlasher.getCol(value));
        value = TableFlasher.constructLongKey(Integer.MAX_VALUE);
        System.out.println("row:" + TableFlasher.getRow(value) + "=" + Integer.MAX_VALUE + " col:" + TableFlasher.getCol(value));
    }

    @Override
    public void onFlashDone(Flasher flasher) {
        this.removeFlasher(flasher.key);
    }

    @Override
    public void onFlash(Flasher aFlasher) {
        this.addFlasher(aFlasher.getKey(), aFlasher);
    }
}

