/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.renderer;

import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import org.icroco.tablemodel.renderer.IRendererStage;

public final class PipelineTableCellRenderer
implements TableCellRenderer {
    private static final long serialVersionUID = -5171942854128414154L;
    private IRendererStage[] modifiers;
    protected final TableCellRenderer delegate;

    public PipelineTableCellRenderer(TableCellRenderer aDelegate, IRendererStage ... aStages) {
        this.delegate = aDelegate == null ? new DefaultTableCellRenderer() : aDelegate;
        ArrayList<IRendererStage> stages = new ArrayList<IRendererStage>(aStages.length);
        this.addModifiers(stages, aStages);
        this.modifiers = stages.toArray(new IRendererStage[0]);
        if (aDelegate instanceof Component) {
            for (int i = 0; i < this.modifiers.length; ++i) {
                this.modifiers[i].initRenderer(null, (Component)((Object)this.delegate));
            }
        }
    }

    public PipelineTableCellRenderer(IRendererStage ... aStages) {
        this((TableCellRenderer)null, aStages);
    }

    private final void addModifiers(List<IRendererStage> aResult, IRendererStage[] aStages) {
        for (int i = 0; i < aStages.length; ++i) {
            aResult.add(aStages[i]);
        }
    }

    public PipelineTableCellRenderer(IRendererStage stage) {
        this(new IRendererStage[]{stage});
    }

    public final void addStage(IRendererStage aStage) {
        if (aStage != null) {
            IRendererStage[] newModifiers = Arrays.copyOf(this.modifiers, this.modifiers.length + 1);
            newModifiers[this.modifiers.length] = aStage;
            this.modifiers = newModifiers;
        }
    }

    @Override
    public Component getTableCellRendererComponent(JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        Object value = aValue;
        for (int i = 0; i < this.modifiers.length; ++i) {
            value = this.modifiers[i].preRender(aTable, value, aIsSelected, aHasFocus, aRow, aColumn);
        }
        if (this.delegate instanceof DefaultTableCellRenderer) {
            ((DefaultTableCellRenderer)this.delegate).setBackground(null);
            ((DefaultTableCellRenderer)this.delegate).setForeground(null);
        }
        JComponent rendered = (JComponent)this.delegate.getTableCellRendererComponent(aTable, value, aIsSelected, aHasFocus, aRow, aColumn);
        for (int i = 0; i < this.modifiers.length; ++i) {
            this.modifiers[i].render(rendered, aTable, value, aIsSelected, aHasFocus, aRow, aColumn);
        }
        return rendered;
    }

    public final IRendererStage[] getModifiers() {
        return this.modifiers;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(50);
        for (IRendererStage st : this.modifiers) {
            buf.append(st.getClass().getSimpleName() + " -> ");
        }
        return buf.toString();
    }
}

