/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.renderer.plugin;

import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JTable;
import org.icroco.tablemodel.renderer.IRendererStage;
import org.icroco.tablemodel.renderer.plugin.ParametersUtil;

public final class CellColorRenderStage
implements IRendererStage {
    private Color bgColor;
    private Color fgColor;

    public CellColorRenderStage(Color aBgColor, Color aFgColor) {
        this.bgColor = aBgColor;
        this.fgColor = aFgColor;
    }

    public CellColorRenderStage(Color aBgColor) {
        this(aBgColor, null);
    }

    public CellColorRenderStage() {
        this(null, null);
    }

    public CellColorRenderStage(String aParameters) throws NumberFormatException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        this(null, null);
        Map<String, String> res = ParametersUtil.parseValue(aParameters);
        String bgColor = res.get("bg");
        String fgColor = res.get("fg");
        if (bgColor == null) {
            throw new IllegalArgumentException("You forget to set parameter 'bg', possible value are '#webcode' or 'static color field define into java.awt.Color'");
        }
        this.bgColor = ParametersUtil.decodeColor(bgColor);
        if (fgColor != null) {
            this.fgColor = ParametersUtil.decodeColor(fgColor);
        }
    }

    @Override
    public void initRenderer(Class<?> aColumnClass, Component aRendered) {
    }

    @Override
    public Object preRender(JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        return aValue;
    }

    @Override
    public void render(Component aRendered, JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        if (this.bgColor != null) {
            aRendered.setBackground(this.bgColor);
        }
        if (this.fgColor != null) {
            aRendered.setBackground(this.fgColor);
        }
    }
}

