/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.renderer.plugin;

import java.awt.Component;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Map;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.text.JTextComponent;
import org.icroco.tablemodel.renderer.IRendererStage;
import org.icroco.tablemodel.renderer.plugin.ParametersUtil;

public final class DateRenderStage
implements IRendererStage {
    private DateFormat dateFormat = null;

    public DateRenderStage(String aParameters) {
        Map<String, String> res = ParametersUtil.parseValue(aParameters);
        String format = res.get("format");
        this.dateFormat = format != null ? new SimpleDateFormat(format) : SimpleDateFormat.getDateInstance();
    }

    @Override
    public void initRenderer(Class<?> aColumnClass, Component aRendered) {
    }

    @Override
    public Object preRender(JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        return aValue;
    }

    @Override
    public void render(Component aRendered, JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        if (aValue != null) {
            if (aRendered instanceof JLabel) {
                ((JLabel)aRendered).setText(aValue instanceof Date ? this.dateFormat.format((Date)aValue) : aValue.toString());
            } else if (aRendered instanceof JTextComponent) {
                ((JTextComponent)aRendered).setText(aValue instanceof Date ? this.dateFormat.format((Date)aValue) : aValue.toString());
            }
        }
    }
}

