/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.renderer.plugin;

import java.awt.Color;
import java.awt.Component;
import java.util.Map;
import javax.swing.JTable;
import javax.swing.UIManager;
import org.icroco.tablemodel.renderer.IRendererStage;
import org.icroco.tablemodel.renderer.plugin.ParametersUtil;

public final class StripedRenderStage
implements IRendererStage {
    public static final Color GENERIC_GRAY = new Color(229, 229, 229);
    private Color evenRowsColor;
    private Color oddRowsColor;

    public StripedRenderStage() {
        Color color = UIManager.getColor("Table.alternateRowColor");
        if (color == null) {
            color = GENERIC_GRAY;
        }
        this.evenRowsColor = color;
        this.oddRowsColor = null;
    }

    public StripedRenderStage(Color aOddRowsColor, Color aEvenRowsColor) {
        this();
        this.oddRowsColor = aOddRowsColor;
        this.evenRowsColor = aEvenRowsColor;
    }

    public StripedRenderStage(String aParameters) throws NumberFormatException, IllegalArgumentException, SecurityException, IllegalAccessException, NoSuchFieldException {
        this();
        Map<String, String> res = ParametersUtil.parseValue(aParameters);
        String odd = res.get("oddBg");
        String even = res.get("evenBg");
        if (odd != null) {
            this.oddRowsColor = ParametersUtil.decodeColor(odd);
        }
        this.evenRowsColor = even != null ? ParametersUtil.decodeColor(even) : null;
    }

    @Override
    public void initRenderer(Class<?> aColumnClass, Component aRendered) {
    }

    @Override
    public Object preRender(JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        return aValue;
    }

    @Override
    public void render(Component aRendered, JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        if (aRow % 2 == 0) {
            aRendered.setBackground(aIsSelected ? this.darker(this.evenRowsColor) : this.evenRowsColor);
        } else if (this.oddRowsColor != null) {
            aRendered.setBackground(aIsSelected ? this.darker(this.oddRowsColor) : this.oddRowsColor);
        }
    }

    private final Color darker(Color aColor) {
        return aColor == null ? null : aColor.darker();
    }
}

