/*
 * Decompiled with CFR 0.152.
 */
package org.icroco.tablemodel.renderer.plugin;

import java.awt.Component;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;
import org.icroco.tablemodel.renderer.IHistoricalValue;
import org.icroco.tablemodel.renderer.IRendererStage;
import org.icroco.tablemodel.renderer.plugin.ParametersUtil;

public final class UpDownIconRenderStage
implements IRendererStage {
    private Icon upIcon;
    private Icon downIcon;
    private Icon equalIcon;

    public UpDownIconRenderStage(Icon aUpIcon, Icon aDownIcon, Icon aEqualIcon) {
        this.upIcon = aUpIcon;
        this.downIcon = aDownIcon;
        this.equalIcon = aEqualIcon;
    }

    public UpDownIconRenderStage() {
        this.upIcon = new ImageIcon(this.getClass().getResource("arrow_up.png"));
        this.downIcon = new ImageIcon(this.getClass().getResource("arrow_down.png"));
        this.equalIcon = new ImageIcon(this.getClass().getResource("arrow_empty.png"));
    }

    public UpDownIconRenderStage(String aParameters) {
        this();
        Map<String, String> res = ParametersUtil.parseValue(aParameters);
        String upIconStr = res.get("up");
        String downIconStr = res.get("down");
        String equalIconStr = res.get("equal");
        if (upIconStr != null) {
            Icon icon = this.upIcon = upIconStr.trim().equalsIgnoreCase("none") ? null : new ImageIcon(this.getClass().getResource(upIconStr));
        }
        if (downIconStr != null) {
            Icon icon = this.downIcon = downIconStr.trim().equalsIgnoreCase("none") ? null : new ImageIcon(this.getClass().getResource(downIconStr));
        }
        if (equalIconStr != null) {
            this.equalIcon = equalIconStr.trim().equalsIgnoreCase("none") ? null : new ImageIcon(this.getClass().getResource(equalIconStr));
        }
    }

    @Override
    public void initRenderer(Class<?> aColumnClass, Component aRendered) {
        if (aRendered instanceof JLabel) {
            ((JLabel)aRendered).setHorizontalTextPosition(2);
            ((JLabel)aRendered).setHorizontalAlignment(4);
        }
    }

    @Override
    public Object preRender(JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        return aValue;
    }

    @Override
    public void render(Component aRendered, JTable aTable, Object aValue, boolean aIsSelected, boolean aHasFocus, int aRow, int aColumn) {
        IHistoricalValue hValue = (IHistoricalValue)aValue;
        double newValue = hValue.getLast() != null ? ((Number)hValue.getLast()).doubleValue() : 0.0;
        double oldValue = hValue.getOld() != null ? ((Number)hValue.getOld()).doubleValue() : newValue;
        JLabel label = (JLabel)aRendered;
        if (oldValue < newValue) {
            label.setIcon(this.upIcon);
        } else if (oldValue > newValue) {
            label.setIcon(this.downIcon);
        } else {
            label.setIcon(this.equalIcon);
        }
    }
}

