/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.client.service;

import com.sun.syndication.feed.atom.Entry;
import com.sun.syndication.feed.atom.Feed;
import java.net.URI;
import java.util.Iterator;
import java.util.List;
import org.ict4h.atomfeed.client.domain.Marker;
import org.ict4h.atomfeed.client.exceptions.AtomFeedClientException;
import org.ict4h.atomfeed.client.repository.AllFeeds;
import org.ict4h.atomfeed.client.util.Util;

public class FeedEnumerator
implements Iterable<Entry>,
Iterator<Entry> {
    private AllFeeds allFeeds;
    private Marker marker;
    private Feed currentFeed;
    private List<Entry> entries;

    public FeedEnumerator(AllFeeds allFeeds, Marker marker) {
        this.allFeeds = allFeeds;
        this.marker = marker;
        this.initializeEnumeration();
    }

    private void initializeEnumeration() {
        if (this.marker.getLastReadEntryId() == null && this.marker.getFeedURIForLastReadEntry() == null) {
            Feed feed;
            this.currentFeed = feed = this.seekFirstFeed(this.marker.getFeedUri());
            this.entries = feed.getEntries();
            return;
        }
        this.setInitialEntries(this.marker.getFeedURIForLastReadEntry());
    }

    private Feed seekFirstFeed(URI uri) {
        Feed currentFeed;
        while ((uri = Util.getPreviousLink(currentFeed = this.allFeeds.getFor(uri))) != null) {
        }
        return currentFeed;
    }

    private void setInitialEntries(URI feedURI) {
        Feed feed = this.allFeeds.getFor(feedURI);
        List initialEntries = feed.getEntries();
        int lastReadEntryIndex = -1;
        for (int i = 0; i < initialEntries.size(); ++i) {
            if (!((Entry)initialEntries.get(i)).getId().equals(this.marker.getLastReadEntryId())) continue;
            lastReadEntryIndex = i;
            break;
        }
        if (lastReadEntryIndex == -1 && this.marker.getLastReadEntryId() != null) {
            throw new AtomFeedClientException("Last Read entry not found in feed.");
        }
        initialEntries.removeAll(initialEntries.subList(0, lastReadEntryIndex + 1));
        this.entries = initialEntries;
        this.currentFeed = feed;
    }

    private void fetchEntries() {
        URI nextArchiveUri = Util.getNextLink(this.currentFeed);
        if (nextArchiveUri != null && this.entries.isEmpty()) {
            this.currentFeed = this.allFeeds.getFor(nextArchiveUri);
            this.entries = this.currentFeed.getEntries();
        }
    }

    @Override
    public boolean hasNext() {
        if (!this.entries.isEmpty()) {
            return true;
        }
        if (Util.getNextLink(this.currentFeed) == null) {
            return false;
        }
        this.fetchEntries();
        return this.hasNext();
    }

    @Override
    public Entry next() {
        Entry entry = this.entries.get(0);
        this.remove();
        return entry;
    }

    @Override
    public void remove() {
        this.entries.remove(0);
    }

    @Override
    public Iterator<Entry> iterator() {
        return this;
    }

    public Feed getCurrentFeed() {
        return this.currentFeed;
    }
}

