/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ResourceBundle;
import org.ict4h.atomfeed.jdbc.AtomFeedJdbcTransactionManager;
import org.ict4h.atomfeed.jdbc.JdbcConnectionProvider;
import org.ict4h.atomfeed.transaction.AFTransactionManager;

public abstract class IntegrationTest {
    private ResourceBundle bundle = ResourceBundle.getBundle("atomfeed");

    protected Connection getConnectionFromDriverManager() throws SQLException {
        return DriverManager.getConnection(this.bundle.getString("jdbc.url"), this.bundle.getString("jdbc.username"), this.bundle.getString("jdbc.password"));
    }

    protected JdbcConnectionProvider getConnectionProvider() {
        return new JdbcConnectionProvider(){
            private Connection providedConnection = null;

            public Connection getConnection() throws SQLException {
                if (this.providedConnection == null) {
                    this.providedConnection = IntegrationTest.this.getConnectionFromDriverManager();
                    this.providedConnection.setAutoCommit(false);
                }
                return this.providedConnection;
            }
        };
    }

    protected String getProperty(String key) {
        return this.bundle.getString(key);
    }

    protected AFTransactionManager getAtomfeedTransactionManager(JdbcConnectionProvider connectionProvider) {
        return new AtomFeedJdbcTransactionManager(connectionProvider);
    }
}

