/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;

public class Configuration {
    private static final String DEFAULT_PROPERTY_FILENAME = "atomfeed.properties";
    private static final Object lockObject = new Object();
    private static Configuration instance;
    private Properties properties;

    private void init(String propertyFilename) throws IOException {
        try (InputStream propertiesFileStream = null;){
            propertiesFileStream = this.getClass().getClassLoader().getResourceAsStream(propertyFilename);
            this.properties = new Properties();
            this.properties.load(propertiesFileStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Configuration getInstance(String propertyFilename) {
        try {
            if (instance == null) {
                Object object = lockObject;
                synchronized (object) {
                    if (instance == null) {
                        instance = new Configuration();
                        instance.init(propertyFilename);
                    }
                }
            }
            return instance;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static Configuration getInstance() {
        return Configuration.getInstance(DEFAULT_PROPERTY_FILENAME);
    }

    public String getJdbcUrl() {
        return this.properties.getProperty("jdbc.url");
    }

    public String getJdbcUsername() {
        return this.properties.getProperty("jdbc.username");
    }

    public String getJdbcPassword() {
        return this.properties.getProperty("jdbc.password");
    }

    public String getSchema() {
        return this.properties.getProperty("atomdb.default_schema");
    }
}

