/*
 * Decompiled with CFR 0.152.
 */
package org.ict4h.atomfeed.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import org.ict4h.atomfeed.jdbc.JdbcConnectionProvider;
import org.ict4h.atomfeed.transaction.AFTransactionManager;
import org.ict4h.atomfeed.transaction.AFTransactionWork;

public class AtomFeedJdbcTransactionManager
implements AFTransactionManager {
    private JdbcConnectionProvider connectionProvider;

    public AtomFeedJdbcTransactionManager(JdbcConnectionProvider connectionProvider) {
        this.connectionProvider = connectionProvider;
    }

    @Override
    public <T> T executeWithTransaction(AFTransactionWork<T> action) throws RuntimeException {
        T t;
        Connection connection = null;
        try {
            connection = this.connectionProvider.getConnection();
            connection.setAutoCommit(false);
            T result = action.execute();
            connection.commit();
            t = result;
        }
        catch (SQLException e) {
            if (connection != null) {
                try {
                    System.err.print("Transaction is being rolled back");
                    connection.rollback();
                }
                catch (SQLException excep) {
                    throw new RuntimeException("Error occurred while trying to rollback transaction", excep);
                }
            }
            throw new RuntimeException("Error occurred while trying to execute in transaction", e);
        }
        return t;
    }
}

