/*
 * Decompiled with CFR 0.152.
 */
package org.idevlab.rjc.sharding;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.idevlab.rjc.RedisException;
import org.idevlab.rjc.sharding.NodeLocator;
import org.idevlab.rjc.sharding.Shard;
import org.idevlab.rjc.util.HashAlgorithm;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HashNodeLocator<T>
implements NodeLocator<T> {
    private TreeMap<Long, Shard<T>> shardedNodes;
    private Collection<? extends Shard<T>> shards;
    private Collection<T> nodes;
    private HashAlgorithm algorithm = HashAlgorithm.MURMUR_HASH;
    private Pattern tagPattern = null;
    public static final Pattern DEFAULT_KEY_TAG_PATTERN = Pattern.compile("\\{(.+?)\\}");

    public HashNodeLocator() {
    }

    public HashNodeLocator(Collection<? extends Shard<T>> shards) {
        this(shards, HashAlgorithm.MURMUR_HASH);
    }

    public HashNodeLocator(Collection<? extends Shard<T>> shards, HashAlgorithm algo) {
        this.shards = new ArrayList<Shard<T>>(shards);
        this.algorithm = algo;
        this.initialize();
    }

    public HashNodeLocator(Collection<? extends Shard<T>> shards, Pattern tagPattern) {
        this(shards, HashAlgorithm.MURMUR_HASH, tagPattern);
    }

    public HashNodeLocator(Collection<? extends Shard<T>> shards, HashAlgorithm algo, Pattern tagPattern) {
        this.shards = new ArrayList<Shard<T>>(shards);
        this.algorithm = algo;
        this.tagPattern = tagPattern;
        this.initialize();
    }

    public void setShards(Collection<? extends Shard<T>> shards) {
        this.shards = new ArrayList<Shard<T>>(shards);
        this.initialize();
    }

    public HashAlgorithm getAlgorithm() {
        return this.algorithm;
    }

    public void setAlgorithm(HashAlgorithm algorithm) {
        this.algorithm = algorithm;
        this.initialize();
    }

    public Pattern getTagPattern() {
        return this.tagPattern;
    }

    public void setTagPattern(Pattern tagPattern) {
        this.tagPattern = tagPattern;
    }

    private void initialize() {
        if (this.shards == null || this.algorithm == null) {
            this.shardedNodes = null;
            return;
        }
        HashSet<String> nodesId = new HashSet<String>(this.shards.size());
        for (Shard<T> node : this.shards) {
            if (node.getShardId() == null) {
                throw new RedisException("Sharded node must have unique shard id and must not be null");
            }
            nodesId.add(node.getShardId());
        }
        if (this.shards.size() != nodesId.size()) {
            throw new RedisException("Sharded node must have unique shard id");
        }
        this.nodes = new ArrayList<T>(this.shards.size());
        for (Shard<T> shard : this.shards) {
            this.nodes.add(shard.getNode());
        }
        this.shardedNodes = new TreeMap();
        for (Shard<T> node : this.shards) {
            for (int n = 0; n < 160 * node.getWeight(); ++n) {
                this.shardedNodes.put(this.algorithm.hash(node.getShardId() + n), node);
            }
        }
    }

    @Override
    public T getNode(String key) {
        SortedMap<Long, Shard<T>> tail = this.shardedNodes.tailMap(this.algorithm.hash(key = this.getKeyTag(key)));
        if (tail.size() == 0) {
            return this.shardedNodes.get(this.shardedNodes.firstKey()).getNode();
        }
        return ((Shard)tail.get(tail.firstKey())).getNode();
    }

    private String getKeyTag(String key) {
        Matcher m;
        if (this.tagPattern != null && (m = this.tagPattern.matcher(key)).find()) {
            return m.group(1);
        }
        return key;
    }

    @Override
    public Collection<? extends T> getNodes() {
        return Collections.unmodifiableCollection(this.nodes);
    }
}

