/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.auto.service.processor;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.ifinalframework.auto.service.processor.ServicesFiles;

public abstract class AbsServiceProcessor
extends AbstractProcessor {
    private static final String DEFAULT_SERVICE_PATH = "services";
    private final Map<String, Map<String, String>> services = new HashMap<String, Map<String, String>>();
    private final Map<String, String> paths = new HashMap<String, String>();

    @Override
    public final boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (roundEnv.processingOver()) {
            this.generateServiceFiles();
            return false;
        }
        return this.doProcess(annotations, roundEnv);
    }

    private void generateServiceFiles() {
        Filer filer = this.processingEnv.getFiler();
        for (Map.Entry<String, Map<String, String>> entry : this.services.entrySet()) {
            String providerInterface = entry.getKey();
            String resourceFile = ServicesFiles.getPath(this.paths.get(providerInterface), providerInterface);
            this.log("Working on resource file: " + resourceFile);
            try {
                TreeMap<String, String> allServices = new TreeMap<String, String>(this.readOldService(filer, resourceFile));
                allServices.putAll(entry.getValue());
                this.log("New service file contents: " + allServices);
                FileObject fileObject = filer.createResource(StandardLocation.CLASS_OUTPUT, "", resourceFile, new Element[0]);
                OutputStream out = fileObject.openOutputStream();
                ServicesFiles.writeServiceFile(allServices, out);
                out.close();
                this.log("Wrote to: " + fileObject.toUri());
            }
            catch (IOException e) {
                this.fatalError("Unable to create " + resourceFile + ", " + e);
                return;
            }
        }
    }

    protected abstract boolean doProcess(Set<? extends TypeElement> var1, RoundEnvironment var2);

    protected void log(String msg) {
        if (this.processingEnv.getOptions().containsKey("debug")) {
            this.processingEnv.getMessager().printMessage(Diagnostic.Kind.NOTE, msg);
        }
    }

    private Map<String, String> readOldService(Filer filer, String resourceFile) {
        try {
            FileObject existingFile = filer.getResource(StandardLocation.CLASS_OUTPUT, "", resourceFile);
            this.log("Looking for existing resource file at " + existingFile.toUri());
            Map<String, String> oldServices = ServicesFiles.readServiceFile(existingFile.openInputStream());
            this.log("Existing service entries: " + oldServices);
            return oldServices;
        }
        catch (IOException e) {
            this.log("Resource file did not already exist.");
            return Collections.emptyMap();
        }
    }

    protected void fatalError(String msg) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, "FATAL ERROR: " + msg);
    }

    protected final void addService(TypeElement service, TypeElement instance) {
        this.addService(service, instance, null, null);
    }

    protected final void addService(TypeElement service, TypeElement instance, String name, String path) {
        String serviceName = service.getQualifiedName().toString();
        Map instances = this.services.computeIfAbsent(serviceName, key -> new HashMap());
        instances.put(instance.getQualifiedName().toString(), name);
        this.paths.putIfAbsent(serviceName, Optional.ofNullable(path).orElse(DEFAULT_SERVICE_PATH));
    }

    protected void error(String msg, Element element, AnnotationMirror annotation) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, element, annotation);
    }
}

