/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.auto.service.processor;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;

public final class ServicesFiles {
    private static final Charset UTF_8 = StandardCharsets.UTF_8;
    private static final String ROOT = "META-INF";
    private static final String PATH_SPE = "/";
    private static final String CHAR_EQUAL = "=";

    private ServicesFiles() {
    }

    static String getPath(String path, String serviceName) {
        return String.join((CharSequence)PATH_SPE, ROOT, path, serviceName);
    }

    static Map<String, String> readServiceFile(InputStream input) throws IOException {
        HashMap<String, String> serviceClasses = new HashMap<String, String>();
        try (BufferedReader r = new BufferedReader(new InputStreamReader(input, UTF_8));){
            String line;
            while ((line = r.readLine()) != null) {
                int commentStart = line.indexOf(35);
                if (commentStart >= 0) {
                    line = line.substring(0, commentStart);
                }
                if ((line = line.trim()).isEmpty()) continue;
                if (line.contains(CHAR_EQUAL)) {
                    String[] split = line.split(CHAR_EQUAL);
                    serviceClasses.put(split[1], split[0]);
                    continue;
                }
                serviceClasses.put(line, null);
            }
            HashMap<String, String> hashMap = serviceClasses;
            return hashMap;
        }
    }

    static void writeServiceFile(Map<String, String> services, OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, UTF_8));
        for (Map.Entry<String, String> entry : services.entrySet()) {
            if (entry.getValue() == null || entry.getValue().isEmpty()) {
                writer.write(entry.getKey());
                writer.newLine();
                continue;
            }
            writer.write(entry.getValue());
            writer.write(CHAR_EQUAL);
            writer.write(entry.getKey());
            writer.newLine();
        }
        writer.flush();
    }
}

