/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.auto.spring.factory.processor;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.lang.model.element.TypeElement;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

final class SpringFactoryFiles
implements Serializable {
    public static final String RESOURCE_FILE = "META-INF/spring.factories";
    private final MultiValueMap<String, String> springFactories = new LinkedMultiValueMap();

    SpringFactoryFiles() {
    }

    public void addSpringFactories(TypeElement clazz, Collection<TypeElement> elements) {
        elements.forEach(item -> this.addSpringFactory(clazz, (TypeElement)item));
    }

    public void addSpringFactory(TypeElement clazz, TypeElement element) {
        this.addSpringFactory(clazz.getQualifiedName().toString(), element.getQualifiedName().toString());
    }

    public void addSpringFactory(String factoryClass, String factoryName) {
        List factories = (List)this.springFactories.get((Object)factoryClass);
        if (factories == null || !factories.contains(factoryName)) {
            this.springFactories.add((Object)factoryClass, (Object)factoryName);
        }
    }

    public MultiValueMap<String, String> getSpringFactories() {
        return this.springFactories;
    }

    void writeFactoryFile(OutputStream output) throws IOException {
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(output, StandardCharsets.UTF_8));
        for (Map.Entry stringListEntry : this.springFactories.entrySet()) {
            String factory = (String)stringListEntry.getKey();
            writer.write("# ");
            writer.write(factory.substring(factory.lastIndexOf(".") + 1));
            writer.newLine();
            writer.write(factory);
            writer.write("=\\");
            writer.newLine();
            List instances = (List)stringListEntry.getValue();
            for (int i = 0; i < instances.size(); ++i) {
                String intance = (String)instances.get(i);
                writer.write(intance);
                if (i != instances.size() - 1) {
                    writer.write(",\\");
                }
                writer.newLine();
            }
        }
        writer.flush();
    }
}

