/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.aopalliance.intercept.MethodInvocation;
import org.ifinalframework.aop.AnnotationMethodInterceptor;
import org.ifinalframework.aop.AnnotationSource;
import org.ifinalframework.aop.DefaultInvocationContext;
import org.ifinalframework.aop.MethodInvocationDispatcher;
import org.ifinalframework.context.expression.MethodMetadata;
import org.springframework.aop.framework.AopProxyUtils;
import org.springframework.context.expression.AnnotatedElementKey;

public class DefaultAnnotationMethodInterceptor<A>
implements AnnotationMethodInterceptor<A> {
    private final Map<AnnotatedElementKey, MethodMetadata> metadataCache = new ConcurrentHashMap<AnnotatedElementKey, MethodMetadata>(1024);
    private final AnnotationSource<A> source;
    private final MethodInvocationDispatcher<A> dispatcher;

    public DefaultAnnotationMethodInterceptor(AnnotationSource<A> source, MethodInvocationDispatcher<A> dispatcher) {
        this.source = source;
        this.dispatcher = dispatcher;
    }

    @Override
    public A findAnnotations(Method method, Class<?> clazz) {
        return this.source.getAnnotations(method, clazz);
    }

    @Override
    public Object invoke(MethodInvocation invocation, A annotations) throws Throwable {
        Class<?> targetClass = this.getTargetClass(invocation.getThis());
        MethodMetadata metadata = this.getOperationMetadata(invocation.getMethod(), targetClass);
        DefaultInvocationContext context = new DefaultInvocationContext(metadata, invocation.getThis(), invocation.getArguments());
        Object operationValue = this.dispatcher.before(context, annotations);
        if (Objects.nonNull(operationValue)) {
            return operationValue;
        }
        Object returnValue = null;
        Throwable throwable = null;
        try {
            returnValue = invocation.proceed();
        }
        catch (Throwable e) {
            throwable = e;
        }
        if (throwable == null) {
            this.dispatcher.afterReturning(context, annotations, returnValue);
        } else {
            this.dispatcher.afterThrowing(context, annotations, throwable);
        }
        this.dispatcher.after(context, annotations, returnValue, throwable);
        if (throwable != null) {
            throw throwable;
        }
        return returnValue;
    }

    private MethodMetadata getOperationMetadata(Method method, Class<?> targetClass) {
        AnnotatedElementKey cacheKey = new AnnotatedElementKey((AnnotatedElement)method, targetClass);
        return this.metadataCache.computeIfAbsent(cacheKey, key -> new MethodMetadata(method, targetClass));
    }

    private Class<?> getTargetClass(Object target) {
        return AopProxyUtils.ultimateTargetClass((Object)target);
    }
}

