/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop;

import com.fasterxml.jackson.annotation.JsonView;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.ifinalframework.aop.InvocationContext;
import org.ifinalframework.context.expression.MethodMetadata;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.util.ObjectUtils;

public class DefaultInvocationContext
implements InvocationContext {
    private final MethodMetadata metadata;
    private final Object target;
    private final Object[] args;
    private final Class<?> view;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    public DefaultInvocationContext(MethodMetadata metadata, Object target, Object[] args) {
        this.metadata = metadata;
        this.target = target;
        this.args = this.extractArgs(metadata.getMethod(), args);
        this.view = this.extractView(metadata.getMethod());
    }

    @Override
    public MethodMetadata metadata() {
        return this.metadata;
    }

    @Override
    public Object target() {
        return this.target;
    }

    @Override
    public Object[] args() {
        return this.args;
    }

    @Override
    public Class<?> view() {
        return this.view;
    }

    @Override
    public Map<String, Object> attributes() {
        return this.attributes;
    }

    @Override
    public void addAttribute(String name, Object value) {
        this.attributes.put(name, value);
    }

    @Override
    public <T> T getAttribute(String name) {
        return (T)this.attributes.get(name);
    }

    private Object[] extractArgs(Method method, Object[] args) {
        if (!method.isVarArgs()) {
            return args;
        }
        Object[] varArgs = ObjectUtils.toObjectArray((Object)args[args.length - 1]);
        Object[] combinedArgs = new Object[args.length - 1 + varArgs.length];
        System.arraycopy(args, 0, combinedArgs, 0, args.length - 1);
        System.arraycopy(varArgs, 0, combinedArgs, args.length - 1, varArgs.length);
        return combinedArgs;
    }

    private Class<?> extractView(Method method) {
        JsonView jsonView = (JsonView)AnnotationUtils.findAnnotation((Method)method, JsonView.class);
        if (jsonView == null) {
            return null;
        }
        Class[] classes = jsonView.value();
        if (classes.length != 1) {
            throw new IllegalArgumentException("@JsonView only supported for cache advice with exactly 1 class argument: " + method.getDeclaringClass().getCanonicalName() + "#" + method.getName());
        }
        return classes[0];
    }
}

