/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.multi;

import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.ifinalframework.aop.InterceptorHandler;
import org.ifinalframework.aop.InvocationContext;
import org.ifinalframework.aop.MethodInvocationDispatcher;
import org.springframework.lang.NonNull;
import org.springframework.util.MultiValueMap;

public abstract class MultiMethodInvocationDispatcher<E, A>
implements MethodInvocationDispatcher<Map<Class<? extends Annotation>, Collection<A>>> {
    private final MultiValueMap<Class<? extends Annotation>, InterceptorHandler<E, A>> handlers;

    public MultiMethodInvocationDispatcher(MultiValueMap<Class<? extends Annotation>, InterceptorHandler<E, A>> handlers) {
        this.handlers = handlers;
    }

    @Override
    public Object before(@NonNull InvocationContext context, @NonNull Map<Class<? extends Annotation>, Collection<A>> annotations) {
        for (Map.Entry entry : this.handlers.entrySet()) {
            List annotationHandlers = (List)entry.getValue();
            for (InterceptorHandler handler : annotationHandlers) {
                Collection<A> as = annotations.get(entry.getKey());
                if (Objects.isNull(as) || as.isEmpty()) continue;
                for (A annotation : as) {
                    E executor = this.getExecutor(annotation);
                    Object value = handler.before(executor, context, annotation);
                    if (!Objects.nonNull(value)) continue;
                    return value;
                }
            }
        }
        return null;
    }

    @Override
    public void afterReturning(@NonNull InvocationContext context, @NonNull Map<Class<? extends Annotation>, Collection<A>> annotations, Object result) {
        for (Map.Entry entry : this.handlers.entrySet()) {
            List annotationHandlers = (List)entry.getValue();
            for (InterceptorHandler handler : annotationHandlers) {
                Collection<A> as = annotations.get(entry.getKey());
                if (Objects.isNull(as) || as.isEmpty()) continue;
                for (A annotation : as) {
                    E executor = this.getExecutor(annotation);
                    handler.afterReturning(executor, context, annotation, result);
                }
            }
        }
    }

    @Override
    public void afterThrowing(@NonNull InvocationContext context, @NonNull Map<Class<? extends Annotation>, Collection<A>> annotations, @NonNull Throwable throwable) {
        for (Map.Entry entry : this.handlers.entrySet()) {
            List annotationHandlers = (List)entry.getValue();
            for (InterceptorHandler handler : annotationHandlers) {
                Collection<A> as = annotations.get(entry.getKey());
                if (Objects.isNull(as) || as.isEmpty()) continue;
                for (A annotation : as) {
                    E executor = this.getExecutor(annotation);
                    handler.afterThrowing(executor, context, annotation, throwable);
                }
            }
        }
    }

    @Override
    public void after(@NonNull InvocationContext context, @NonNull Map<Class<? extends Annotation>, Collection<A>> annotations, Object result, Throwable throwable) {
        for (Map.Entry entry : this.handlers.entrySet()) {
            List annotationHandlers = (List)entry.getValue();
            for (InterceptorHandler handler : annotationHandlers) {
                Collection<A> as = annotations.get(entry.getKey());
                if (Objects.isNull(as) || as.isEmpty()) continue;
                for (A annotation : as) {
                    E executor = this.getExecutor(annotation);
                    handler.after(executor, context, annotation, result, throwable);
                }
            }
        }
    }

    @NonNull
    protected abstract E getExecutor(A var1);
}

