/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.aop.single;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.ifinalframework.aop.InterceptorHandler;
import org.ifinalframework.aop.InvocationContext;
import org.ifinalframework.aop.MethodInvocationDispatcher;
import org.springframework.lang.NonNull;

public abstract class SingleMethodInvocationDispatcher<E, A>
implements MethodInvocationDispatcher<Collection<A>> {
    private List<InterceptorHandler<E, A>> handlers;

    protected SingleMethodInvocationDispatcher(List<InterceptorHandler<E, A>> handlers) {
        this.handlers = handlers;
    }

    @Override
    public Object before(@NonNull InvocationContext context, @NonNull Collection<A> annotations) {
        for (InterceptorHandler<E, A> handler : this.handlers) {
            for (A annotation : annotations) {
                E handlerExecutor = this.getExecutor(annotation);
                Object value = handler.before(handlerExecutor, context, annotation);
                if (!Objects.nonNull(value)) continue;
                return value;
            }
        }
        return null;
    }

    @Override
    public void afterReturning(@NonNull InvocationContext context, @NonNull Collection<A> annotations, Object result) {
        for (InterceptorHandler<E, A> handler : this.handlers) {
            for (A annotation : annotations) {
                E handlerExecutor = this.getExecutor(annotation);
                handler.afterReturning(handlerExecutor, context, annotation, result);
            }
        }
    }

    @Override
    public void afterThrowing(@NonNull InvocationContext context, @NonNull Collection<A> annotations, @NonNull Throwable throwable) {
        for (InterceptorHandler<E, A> handler : this.handlers) {
            for (A annotation : annotations) {
                E handlerExecutor = this.getExecutor(annotation);
                handler.afterThrowing(handlerExecutor, context, annotation, throwable);
            }
        }
    }

    @Override
    public void after(@NonNull InvocationContext context, @NonNull Collection<A> annotations, Object result, Throwable throwable) {
        for (InterceptorHandler<E, A> handler : this.handlers) {
            for (A annotation : annotations) {
                E handlerExecutor = this.getExecutor(annotation);
                handler.after(handlerExecutor, context, annotation, result, throwable);
            }
        }
    }

    @NonNull
    protected abstract E getExecutor(A var1);
}

