/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.exception;

import org.ifinalframework.context.util.Messages;
import org.ifinalframework.core.IException;
import org.ifinalframework.core.result.Responsible;
import org.springframework.lang.NonNull;

public class ServiceException
extends RuntimeException
implements Responsible,
IException {
    private final Integer status;
    private final String description;
    private final String code;
    private final String message;
    private final transient Object[] args;

    public ServiceException(Integer status, String description, IException exception, Object ... args) {
        this(status, description, exception.getCode(), exception.getMessage(), args);
    }

    public ServiceException(Integer status, String description) {
        this(status, description, status.toString(), description, new Object[0]);
    }

    public ServiceException(Integer status, String description, String code, String message, Object ... args) {
        super(description);
        this.status = status;
        this.description = description;
        this.code = code;
        this.message = Messages.getMessage(message, message, args);
        this.args = args;
    }

    @NonNull
    public Integer getStatus() {
        return this.status;
    }

    @NonNull
    public String getDescription() {
        return this.description;
    }

    @NonNull
    public String getCode() {
        return this.code;
    }

    @Override
    @NonNull
    public String getMessage() {
        return this.message;
    }

    public Object[] getArgs() {
        return this.args;
    }
}

