/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.exception.result;

import java.util.stream.Collectors;
import javax.validation.ConstraintViolation;
import javax.validation.ConstraintViolationException;
import org.ifinalframework.context.exception.result.ResultExceptionHandler;
import org.ifinalframework.core.ResponseStatus;
import org.ifinalframework.core.result.R;
import org.ifinalframework.core.result.Result;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.core.annotation.Order;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;

@Order(value=0)
@Component
@ConditionalOnClass(value={ConstraintViolationException.class})
public class ViolationResultExceptionHandler
implements ResultExceptionHandler<ConstraintViolationException> {
    public boolean supports(@NonNull Throwable t) {
        return t instanceof ConstraintViolationException;
    }

    @NonNull
    public Result<?> handle(@NonNull ConstraintViolationException e) {
        return R.failure((Integer)ResponseStatus.BAD_REQUEST.getCode(), (String)e.getConstraintViolations().stream().map(ConstraintViolation::getMessage).collect(Collectors.joining(",")));
    }
}

