/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.result;

import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Resource;
import lombok.Generated;
import org.ifinalframework.context.exception.ServiceException;
import org.ifinalframework.context.result.ResultConsumer;
import org.ifinalframework.context.result.ResultSupplier;
import org.ifinalframework.core.result.R;
import org.ifinalframework.core.result.Result;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class SimpleResultSupplier
implements ResultSupplier {
    @Generated
    private static final Logger logger = LoggerFactory.getLogger(SimpleResultSupplier.class);
    @Resource
    private List<ResultConsumer<?>> resultConsumers;

    @Override
    public <T> Result<T> get(Supplier<T> supplier) {
        Result<T> result = this.doGet(supplier);
        this.doConsumers(result);
        return result;
    }

    private <T> Result<T> doGet(Supplier<T> supplier) {
        try {
            return R.success(supplier.get());
        }
        catch (ServiceException e) {
            logger.warn("result supplier error: ", (Throwable)e);
            return R.failure((Integer)e.getStatus(), (String)e.getDescription(), (String)e.getCode(), (String)e.getMessage());
        }
        catch (Exception e) {
            logger.error("result supplier exception: ", (Throwable)e);
            return R.failure((Integer)500, (String)e.getMessage());
        }
    }

    private void doConsumers(Result result) {
        if (CollectionUtils.isEmpty(this.resultConsumers)) {
            return;
        }
        for (ResultConsumer<?> consumer : this.resultConsumers) {
            if (!consumer.test(result)) continue;
            consumer.accept(result);
        }
    }

    @Generated
    public void setResultConsumers(List<ResultConsumer<?>> resultConsumers) {
        this.resultConsumers = resultConsumers;
    }
}

