/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.result.consumer;

import com.github.pagehelper.Page;
import com.github.pagehelper.PageInfo;
import java.util.Objects;
import org.ifinalframework.context.result.ResultConsumer;
import org.ifinalframework.core.result.Pagination;
import org.ifinalframework.core.result.Result;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnClass(value={Page.class})
public class PageResultConsumer
implements ResultConsumer<Page<?>> {
    @Override
    public void accept(Result<Page<?>> result) {
        Page page = (Page)Objects.requireNonNull(result.getData());
        result.setPagination(this.buildPageInfo(page));
    }

    private Pagination buildPageInfo(Page<?> page) {
        PageInfo pageInfo = page.toPageInfo();
        Pagination result = new Pagination();
        result.setPage(Integer.valueOf(pageInfo.getPageNum()));
        result.setSize(Integer.valueOf(pageInfo.getPageSize()));
        result.setPages(Integer.valueOf(pageInfo.getPages()));
        result.setTotal(Long.valueOf(pageInfo.getTotal()));
        result.setFirstPage(Boolean.valueOf(pageInfo.isIsFirstPage()));
        result.setLastPage(Boolean.valueOf(pageInfo.isIsLastPage()));
        return result;
    }

    @Override
    public boolean test(Result<?> result) {
        return Objects.nonNull(result.getData()) && result.getData() instanceof Page;
    }
}

