/*
 * Decompiled with CFR 0.152.
 */
package org.ifinalframework.context.util;

import java.util.Objects;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;

public final class Messages {
    private static final Logger logger = LoggerFactory.getLogger(Messages.class);
    private static MessageSource messageSource;

    private Messages() {
    }

    public static String getMessage(String code, Object ... args) {
        return Messages.getMessage(code, null, args);
    }

    public static String getMessage(String code, String defaultMessage, Object ... args) {
        if (messageSource == null) {
            return defaultMessage != null ? defaultMessage : MessageFormatter.arrayFormat((String)code, (Object[])args).getMessage();
        }
        try {
            String message = messageSource.getMessage(code, args, null, LocaleContextHolder.getLocale());
            if (Objects.isNull(message)) {
                return MessageFormatter.arrayFormat((String)code, (Object[])args).getMessage();
            }
            return message;
        }
        catch (Exception e) {
            logger.warn("get message error:{}", (Object)code, (Object)e);
            return code;
        }
    }

    @Generated
    public static void setMessageSource(MessageSource messageSource) {
        Messages.messageSource = messageSource;
    }
}

